/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.torel;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.data.Except;
import org.apache.drill.common.logical.data.Filter;
import org.apache.drill.common.logical.data.GroupingAggregate;
import org.apache.drill.common.logical.data.Intersect;
import org.apache.drill.common.logical.data.Join;
import org.apache.drill.common.logical.data.Limit;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.common.logical.data.Project;
import org.apache.drill.common.logical.data.Scan;
import org.apache.drill.common.logical.data.Union;
import org.apache.drill.common.logical.data.visitors.AbstractLogicalVisitor;
import org.apache.drill.exec.planner.logical.DrillAggregateRel;
import org.apache.drill.exec.planner.logical.DrillExceptRel;
import org.apache.drill.exec.planner.logical.DrillIntersectRel;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.logical.DrillLimitRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillSortRel;
import org.apache.drill.exec.planner.logical.DrillUnionRel;
import org.apache.drill.exec.planner.logical.ScanFieldDeterminer;

public class ConversionContext
implements RelOptTable.ToRelContext {
    private static final ConverterVisitor VISITOR = new ConverterVisitor();
    private final Map<Scan, ScanFieldDeterminer.FieldList> scanFieldLists;
    private final RelOptCluster cluster;

    public ConversionContext(RelOptCluster cluster, LogicalPlan plan) {
        this.scanFieldLists = ScanFieldDeterminer.getFieldLists(plan);
        this.cluster = cluster;
    }

    public RelOptCluster getCluster() {
        return this.cluster;
    }

    public List<RelHint> getTableHints() {
        return Collections.emptyList();
    }

    private ScanFieldDeterminer.FieldList getFieldList(Scan scan) {
        assert (this.scanFieldLists.containsKey(scan));
        return this.scanFieldLists.get(scan);
    }

    public RexBuilder getRexBuilder() {
        return this.cluster.getRexBuilder();
    }

    public RelTraitSet getLogicalTraits() {
        RelTraitSet set = RelTraitSet.createEmpty();
        set.add((Object)DrillRel.DRILL_LOGICAL);
        return set;
    }

    public RelNode toRel(LogicalOperator operator) throws InvalidRelException {
        return operator.accept(VISITOR, this);
    }

    public RexNode toRex(LogicalExpression e) {
        return null;
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.cluster.getTypeFactory();
    }

    public RelOptTable getTable(Scan scan) {
        ScanFieldDeterminer.FieldList list = this.getFieldList(scan);
        return null;
    }

    public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, List<String> viewPath) {
        throw new UnsupportedOperationException();
    }

    private static class ConverterVisitor
    extends AbstractLogicalVisitor<RelNode, ConversionContext, InvalidRelException> {
        private ConverterVisitor() {
        }

        @Override
        public RelNode visitScan(Scan scan, ConversionContext context) {
            return null;
        }

        @Override
        public RelNode visitFilter(Filter filter, ConversionContext context) throws InvalidRelException {
            return null;
        }

        @Override
        public RelNode visitProject(Project project, ConversionContext context) throws InvalidRelException {
            return null;
        }

        @Override
        public RelNode visitOrder(Order order, ConversionContext context) throws InvalidRelException {
            return DrillSortRel.convert(order, context);
        }

        @Override
        public RelNode visitJoin(Join join, ConversionContext context) throws InvalidRelException {
            return DrillJoinRel.convert(join, context);
        }

        @Override
        public RelNode visitLimit(Limit limit, ConversionContext context) throws InvalidRelException {
            return DrillLimitRel.convert(limit, context);
        }

        @Override
        public RelNode visitUnion(Union union, ConversionContext context) throws InvalidRelException {
            return DrillUnionRel.convert(union, context);
        }

        @Override
        public RelNode visitExcept(Except except, ConversionContext context) throws InvalidRelException {
            return DrillExceptRel.convert(except, context);
        }

        @Override
        public RelNode visitIntersect(Intersect intersect, ConversionContext context) throws InvalidRelException {
            return DrillIntersectRel.convert(intersect, context);
        }

        @Override
        public RelNode visitGroupingAggregate(GroupingAggregate groupBy, ConversionContext context) throws InvalidRelException {
            return DrillAggregateRel.convert(groupBy, context);
        }
    }
}

