/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.handlers.UseSchemaHandler;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;

public class SqlUseSchema
extends DrillSqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("USE_SCHEMA", SqlKind.OTHER_DDL){

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlUseSchema(pos, (SqlIdentifier)operands[0]);
        }
    };
    private SqlIdentifier schema;

    public SqlUseSchema(SqlParserPos pos, SqlIdentifier schema) {
        super(pos);
        this.schema = schema;
        assert (schema != null);
    }

    public List<SqlNode> getOperandList() {
        return Collections.singletonList(this.schema);
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("USE");
        this.schema.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return new UseSchemaHandler(config.getContext());
    }

    public String getSchema() {
        return this.schema.toString();
    }
}

