/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.ShowSchemasHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class SqlShowSchemas
extends DrillSqlCall {
    private final SqlNode likePattern;
    private final SqlNode whereClause;
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("SHOW_SCHEMAS", SqlKind.OTHER){

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlShowSchemas(pos, operands[0], operands[1]);
        }
    };

    public SqlShowSchemas(SqlParserPos pos, SqlNode likePattern, SqlNode whereClause) {
        super(pos);
        this.likePattern = likePattern;
        this.whereClause = whereClause;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> opList = Lists.newArrayList();
        opList.add(this.likePattern);
        opList.add(this.whereClause);
        return opList;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("SHOW");
        writer.keyword("SCHEMAS");
        if (this.likePattern != null) {
            writer.keyword("LIKE");
            this.likePattern.unparse(writer, leftPrec, rightPrec);
        }
        if (this.whereClause != null) {
            this.whereClause.unparse(writer, leftPrec, rightPrec);
        }
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return new ShowSchemasHandler(config);
    }

    public SqlNode getLikePattern() {
        return this.likePattern;
    }

    public SqlNode getWhereClause() {
        return this.whereClause;
    }
}

