/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Util;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.MetastoreDropTableMetadataHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.apache.drill.exec.util.Pointer;

public class SqlDropTableMetadata
extends DrillSqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DROP_TABLE_METADATA", SqlKind.OTHER){

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlDropTableMetadata(pos, (SqlIdentifier)operands[0], (SqlLiteral)operands[1], (SqlLiteral)operands[2]);
        }
    };
    private final SqlIdentifier tableName;
    private final boolean checkMetadataExistence;
    private final DropMetadataType dropType;

    public SqlDropTableMetadata(SqlParserPos pos, SqlIdentifier tableName, SqlLiteral dropType, SqlLiteral checkMetadataExistence) {
        super(pos);
        this.tableName = tableName;
        this.dropType = DropMetadataType.valueOf(dropType.getStringValue().toUpperCase());
        this.checkMetadataExistence = checkMetadataExistence.booleanValue();
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return Arrays.asList(this.tableName, SqlLiteral.createCharString((String)this.dropType.name(), (SqlParserPos)SqlParserPos.ZERO), SqlLiteral.createBoolean((boolean)this.checkMetadataExistence, (SqlParserPos)SqlParserPos.ZERO));
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ANALYZE");
        writer.keyword("TABLE");
        this.tableName.unparse(writer, leftPrec, rightPrec);
        writer.keyword("DROP");
        writer.keyword(this.dropType.name());
        if (this.checkMetadataExistence) {
            writer.keyword("IF");
            writer.keyword("EXISTS");
        }
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config, Pointer<String> textPlan) {
        return new MetastoreDropTableMetadataHandler(config, textPlan);
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return this.getSqlHandler(config, null);
    }

    public List<String> getSchemaPath() {
        return SchemaUtilities.getSchemaPath(this.tableName);
    }

    public String getName() {
        return (String)Util.last((List)this.tableName.names);
    }

    public boolean checkMetadataExistence() {
        return this.checkMetadataExistence;
    }

    public DropMetadataType getDropType() {
        return this.dropType;
    }

    public static enum DropMetadataType {
        METADATA,
        STATISTICS;

    }
}

