/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.DropAllAliasesHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;

public class SqlDropAllAliases
extends DrillSqlCall {
    private final SqlNode isPublic;
    private final SqlNode aliasKind;
    private final SqlNode user;
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DROP_ALIAS", SqlKind.OTHER_DDL){

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return SqlDropAllAliases.builder().pos(pos).aliasKind(operands[0]).isPublic(operands[1]).user(operands[2]).build();
        }
    };

    private SqlDropAllAliases(SqlDropAllAliasesBuilder builder) {
        super(builder.pos);
        this.isPublic = builder.isPublic;
        this.aliasKind = builder.aliasKind;
        this.user = builder.user;
    }

    public static SqlDropAllAliasesBuilder builder() {
        return new SqlDropAllAliasesBuilder();
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> opList = new ArrayList<SqlNode>();
        opList.add(this.aliasKind);
        opList.add(this.isPublic);
        opList.add(this.user);
        return opList;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        writer.keyword("ALL");
        if (((SqlLiteral)this.isPublic).booleanValue()) {
            writer.keyword("PUBLIC");
        }
        writer.keyword("ALIASES");
        writer.keyword("FOR");
        writer.keyword(((SqlLiteral)this.aliasKind).toValue());
        if (this.user != null) {
            writer.keyword("AS");
            writer.keyword("USER");
            this.user.unparse(writer, leftPrec, rightPrec);
        }
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return new DropAllAliasesHandler(config);
    }

    public SqlNode getIsPublic() {
        return this.isPublic;
    }

    public SqlNode getAliasKind() {
        return this.aliasKind;
    }

    public SqlNode getUser() {
        return this.user;
    }

    public static class SqlDropAllAliasesBuilder {
        private SqlParserPos pos;
        private SqlNode isPublic;
        private SqlNode aliasKind;
        private SqlNode user;

        public SqlDropAllAliasesBuilder pos(SqlParserPos pos) {
            this.pos = pos;
            return this;
        }

        public SqlDropAllAliasesBuilder isPublic(SqlNode isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public SqlDropAllAliasesBuilder aliasKind(SqlNode aliasKind) {
            this.aliasKind = aliasKind;
            return this;
        }

        public SqlDropAllAliasesBuilder user(SqlNode user) {
            this.user = user;
            return this;
        }

        public SqlDropAllAliases build() {
            return new SqlDropAllAliases(this);
        }
    }
}

