/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.CreateTableHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerUtil;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class SqlCreateTable
extends DrillSqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE_TABLE", SqlKind.CREATE_TABLE){

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            Preconditions.checkArgument(operands.length == 6, "SqlCreateTable.createCall() has to get 6 operands!");
            return new SqlCreateTable(pos, (SqlIdentifier)operands[0], (SqlNodeList)operands[1], (SqlNodeList)operands[2], operands[3], (SqlLiteral)operands[4], (SqlLiteral)operands[5]);
        }
    };
    private final SqlIdentifier tblName;
    private final SqlNodeList fieldList;
    private final SqlNodeList partitionColumns;
    private final SqlNode query;
    private final SqlLiteral isTemporary;
    private final SqlLiteral tableNonExistenceCheck;

    public SqlCreateTable(SqlParserPos pos, SqlIdentifier tblName, SqlNodeList fieldList, SqlNodeList partitionColumns, SqlNode query, SqlLiteral isTemporary, SqlLiteral tableNonExistenceCheck) {
        super(pos);
        this.tblName = tblName;
        this.fieldList = fieldList;
        this.partitionColumns = partitionColumns;
        this.query = query;
        this.isTemporary = isTemporary;
        this.tableNonExistenceCheck = tableNonExistenceCheck;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> ops = Lists.newArrayList();
        ops.add((SqlNode)this.tblName);
        ops.add((SqlNode)this.fieldList);
        ops.add((SqlNode)this.partitionColumns);
        ops.add(this.query);
        ops.add((SqlNode)this.isTemporary);
        ops.add((SqlNode)this.tableNonExistenceCheck);
        return ops;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.isTemporary.booleanValue()) {
            writer.keyword("TEMPORARY");
        }
        writer.keyword("TABLE");
        if (this.tableNonExistenceCheck.booleanValue()) {
            writer.keyword("IF");
            writer.keyword("NOT");
            writer.keyword("EXISTS");
        }
        this.tblName.unparse(writer, leftPrec, rightPrec);
        if (this.fieldList.size() > 0) {
            SqlHandlerUtil.unparseSqlNodeList(writer, leftPrec, rightPrec, this.fieldList);
        }
        if (this.partitionColumns.size() > 0) {
            writer.keyword("PARTITION BY");
            SqlHandlerUtil.unparseSqlNodeList(writer, leftPrec, rightPrec, this.partitionColumns);
        }
        writer.keyword("AS");
        this.query.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return this.getSqlHandler(config, null);
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config, Pointer<String> textPlan) {
        assert (textPlan != null) : "Create table statement should have a plan";
        return new CreateTableHandler(config, textPlan);
    }

    public List<String> getSchemaPath() {
        return SchemaUtilities.getSchemaPath(this.tblName);
    }

    public String getName() {
        if (this.tblName.isSimple()) {
            return this.tblName.getSimple();
        }
        return (String)this.tblName.names.get(this.tblName.names.size() - 1);
    }

    public List<String> getFieldNames() {
        ArrayList<String> columnNames = Lists.newArrayList();
        for (SqlNode node : this.fieldList.getList()) {
            columnNames.add(node.toString());
        }
        return columnNames;
    }

    public List<String> getPartitionColumns() {
        ArrayList<String> columnNames = Lists.newArrayList();
        for (SqlNode node : this.partitionColumns.getList()) {
            columnNames.add(node.toString());
        }
        return columnNames;
    }

    public SqlNode getQuery() {
        return this.query;
    }

    public boolean isTemporary() {
        return this.isTemporary.booleanValue();
    }

    public boolean checkTableNonExistence() {
        return this.tableNonExistenceCheck.booleanValue();
    }
}

