/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.drill.exec.planner.sql.parser.DrillCompoundIdentifier;
import org.apache.drill.exec.planner.sql.parser.DrillSqlDescribeTable;
import org.apache.drill.exec.planner.sql.parser.DrillSqlResetOption;
import org.apache.drill.exec.planner.sql.parser.DrillSqlSetOption;
import org.apache.drill.exec.planner.sql.parser.SqlAnalyzeTable;
import org.apache.drill.exec.planner.sql.parser.SqlCreateFunction;
import org.apache.drill.exec.planner.sql.parser.SqlCreateTable;
import org.apache.drill.exec.planner.sql.parser.SqlCreateView;
import org.apache.drill.exec.planner.sql.parser.SqlDropFunction;
import org.apache.drill.exec.planner.sql.parser.SqlDropTable;
import org.apache.drill.exec.planner.sql.parser.SqlDropTableMetadata;
import org.apache.drill.exec.planner.sql.parser.SqlDropView;
import org.apache.drill.exec.planner.sql.parser.SqlMetastoreAnalyzeTable;
import org.apache.drill.exec.planner.sql.parser.SqlRefreshMetadata;
import org.apache.drill.exec.planner.sql.parser.SqlSchema;
import org.apache.drill.exec.planner.sql.parser.SqlShowFiles;
import org.apache.drill.exec.planner.sql.parser.SqlShowSchemas;
import org.apache.drill.exec.planner.sql.parser.SqlUseSchema;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;

public class CompoundIdentifierConverter
extends SqlShuttle {
    private static final Map<Class<? extends SqlCall>, RewriteType[]> REWRITE_RULES;
    private boolean enableComplex = true;
    private boolean allowNoTableRefCompoundIdentifier = false;

    public CompoundIdentifierConverter(boolean allowNoTableRefCompoundIdentifier) {
        this.allowNoTableRefCompoundIdentifier = allowNoTableRefCompoundIdentifier;
    }

    public SqlNode visit(SqlIdentifier id) {
        if (id instanceof DrillCompoundIdentifier) {
            DrillCompoundIdentifier compoundIdentifier = (DrillCompoundIdentifier)id;
            if (this.enableComplex) {
                return compoundIdentifier.getAsSqlNode(this.allowNoTableRefCompoundIdentifier);
            }
            return compoundIdentifier.getAsCompoundIdentifier();
        }
        return id;
    }

    public SqlNode visit(SqlCall call) {
        ComplexExpressionAware argHandler = new ComplexExpressionAware(call);
        boolean localEnableComplex = this.enableComplex;
        if (call.getKind() == SqlKind.UNNEST) {
            this.enableComplex = true;
        }
        call.getOperator().acceptCall((SqlVisitor)this, call, false, (SqlBasicVisitor.ArgHandler)argHandler);
        this.enableComplex = localEnableComplex;
        return (SqlNode)argHandler.result();
    }

    private static RewriteType[] arrayOf(RewriteType ... types) {
        return types;
    }

    static {
        RewriteType E = RewriteType.ENABLE;
        RewriteType D = RewriteType.DISABLE;
        REWRITE_RULES = ImmutableMap.builder().put(SqlAnalyzeTable.class, CompoundIdentifierConverter.arrayOf(D, D, E, D)).put(SqlMetastoreAnalyzeTable.class, CompoundIdentifierConverter.arrayOf(D, E, D, D, D)).put(SqlDropTableMetadata.class, CompoundIdentifierConverter.arrayOf(D, D, D)).put(SqlSelect.class, CompoundIdentifierConverter.arrayOf(D, E, D, E, E, E, E, E, E, D, D, D)).put(SqlCreateTable.class, CompoundIdentifierConverter.arrayOf(D, D, D, E, D, D)).put(SqlCreateView.class, CompoundIdentifierConverter.arrayOf(D, E, E, D)).put(DrillSqlDescribeTable.class, CompoundIdentifierConverter.arrayOf(D, D, E)).put(SqlDropView.class, CompoundIdentifierConverter.arrayOf(D, D)).put(SqlShowFiles.class, CompoundIdentifierConverter.arrayOf(D)).put(SqlShowSchemas.class, CompoundIdentifierConverter.arrayOf(D, D)).put(SqlUseSchema.class, CompoundIdentifierConverter.arrayOf(D)).put(SqlJoin.class, CompoundIdentifierConverter.arrayOf(D, D, D, D, D, E)).put(SqlOrderBy.class, CompoundIdentifierConverter.arrayOf(D, E, D, D)).put(SqlDropTable.class, CompoundIdentifierConverter.arrayOf(D, D)).put(SqlRefreshMetadata.class, CompoundIdentifierConverter.arrayOf(D, D, E)).put(DrillSqlSetOption.class, CompoundIdentifierConverter.arrayOf(D, D, D)).put(DrillSqlResetOption.class, CompoundIdentifierConverter.arrayOf(D, D)).put(SqlCreateFunction.class, CompoundIdentifierConverter.arrayOf(D)).put(SqlDropFunction.class, CompoundIdentifierConverter.arrayOf(D)).put(SqlSchema.Create.class, CompoundIdentifierConverter.arrayOf(D, D, D, D, D, D)).put(SqlSchema.Drop.class, CompoundIdentifierConverter.arrayOf(D, D)).put(SqlSchema.Describe.class, CompoundIdentifierConverter.arrayOf(D, D)).put(SqlSchema.Add.class, CompoundIdentifierConverter.arrayOf(D, D, D, D, D, D)).put(SqlSchema.Remove.class, CompoundIdentifierConverter.arrayOf(D, D, D, D, D)).build();
    }

    private class ComplexExpressionAware
    implements SqlBasicVisitor.ArgHandler<SqlNode> {
        private final SqlCall call;
        private final SqlNode[] clonedOperands;
        private final RewriteType[] rewriteTypes;
        private boolean update;

        public ComplexExpressionAware(SqlCall call) {
            this.call = call;
            this.update = false;
            List operands = call.getOperandList();
            this.clonedOperands = operands.toArray(new SqlNode[0]);
            this.rewriteTypes = (RewriteType[])REWRITE_RULES.get(call.getClass());
        }

        public SqlNode result() {
            if (this.update) {
                return this.call.getOperator().createCall(this.call.getFunctionQuantifier(), this.call.getParserPosition(), this.clonedOperands);
            }
            return this.call;
        }

        public SqlNode visitChild(SqlVisitor<SqlNode> visitor, SqlNode expr, int i, SqlNode operand) {
            if (operand == null) {
                return null;
            }
            boolean localEnableComplex = CompoundIdentifierConverter.this.enableComplex;
            if (this.rewriteTypes != null) {
                switch (this.rewriteTypes[i]) {
                    case DISABLE: {
                        CompoundIdentifierConverter.this.enableComplex = false;
                        break;
                    }
                    case ENABLE: {
                        CompoundIdentifierConverter.this.enableComplex = true;
                    }
                }
            }
            SqlNode newOperand = (SqlNode)operand.accept((SqlVisitor)CompoundIdentifierConverter.this);
            CompoundIdentifierConverter.this.enableComplex = localEnableComplex;
            if (newOperand != operand) {
                this.update = true;
            }
            this.clonedOperands[i] = newOperand;
            return newOperand;
        }
    }

    static enum RewriteType {
        UNCHANGED,
        DISABLE,
        ENABLE;

    }
}

