/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.dotdrill.View;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerUtil;
import org.apache.drill.exec.planner.sql.parser.SqlCreateView;
import org.apache.drill.exec.planner.sql.parser.SqlDropView;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ViewHandler
extends DefaultSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(ViewHandler.class);
    protected QueryContext context;

    public ViewHandler(SqlHandlerConfig config) {
        super(config);
        this.context = config.getContext();
    }

    public static class DropView
    extends ViewHandler {
        public DropView(SqlHandlerConfig config) {
            super(config);
        }

        @Override
        public PhysicalPlan getPlan(SqlNode sqlNode) throws IOException, ForemanSetupException {
            SqlDropView dropView = DropView.unwrap(sqlNode, SqlDropView.class);
            String viewName = DrillStringUtils.removeLeadingSlash(dropView.getName());
            AbstractSchema drillSchema = SchemaUtilities.resolveToMutableDrillSchema(this.context.getNewDefaultSchema(), dropView.getSchemaPath());
            String schemaPath = drillSchema.getFullSchemaName();
            Table viewToDrop = SqlHandlerUtil.getTableFromSchema(drillSchema, viewName);
            if (dropView.checkViewExistence()) {
                if (viewToDrop == null || viewToDrop.getJdbcTableType() != Schema.TableType.VIEW) {
                    return DirectPlan.createDirectPlan(this.context, false, String.format("View [%s] not found in schema [%s].", viewName, schemaPath));
                }
            } else {
                if (viewToDrop != null && viewToDrop.getJdbcTableType() != Schema.TableType.VIEW) {
                    throw UserException.validationError().message("[%s] is not a VIEW in schema [%s]", viewName, schemaPath).build(logger);
                }
                if (viewToDrop == null) {
                    throw UserException.validationError().message("Unknown view [%s] in schema [%s].", viewName, schemaPath).build(logger);
                }
            }
            SqlHandlerUtil.dropViewFromSchema(drillSchema, viewName);
            return DirectPlan.createDirectPlan(this.context, true, String.format("View [%s] deleted successfully from schema [%s].", viewName, schemaPath));
        }
    }

    public static class CreateView
    extends ViewHandler {
        public CreateView(SqlHandlerConfig config) {
            super(config);
        }

        @Override
        public PhysicalPlan getPlan(SqlNode sqlNode) throws ValidationException, RelConversionException, IOException, ForemanSetupException {
            SqlCreateView createView = CreateView.unwrap(sqlNode, SqlCreateView.class);
            String newViewName = DrillStringUtils.removeLeadingSlash(createView.getName());
            this.config.getConverter().disallowTemporaryTables();
            String viewSql = createView.getQuery().toSqlString(null, true).getSql();
            DefaultSqlHandler.ConvertedRelNode convertedRelNode = this.validateAndConvert(createView.getQuery());
            RelDataType validatedRowType = convertedRelNode.getValidatedRowType();
            RelNode queryRelNode = convertedRelNode.getConvertedNode();
            RelNode newViewRelNode = SqlHandlerUtil.resolveNewTableRel(true, createView.getFieldNames(), validatedRowType, queryRelNode);
            SchemaPlus defaultSchema = this.context.getNewDefaultSchema();
            AbstractSchema drillSchema = SchemaUtilities.resolveToMutableDrillSchema(defaultSchema, createView.getSchemaPath());
            View view = new View(newViewName, viewSql, newViewRelNode.getRowType(), SchemaUtilities.getSchemaPathAsList(defaultSchema));
            String schemaPath = drillSchema.getFullSchemaName();
            if (!this.checkViewCreationPossibility(drillSchema, createView, this.context)) {
                return DirectPlan.createDirectPlan(this.context, false, String.format("A table or view with given name [%s] already exists in schema [%s]", view.getName(), schemaPath));
            }
            boolean replaced = drillSchema.createView(view);
            String summary = String.format("View '%s' %s successfully in '%s' schema", newViewName, replaced ? "replaced" : "created", drillSchema.getFullSchemaName());
            return DirectPlan.createDirectPlan(this.context, true, summary);
        }

        private boolean checkViewCreationPossibility(AbstractSchema drillSchema, SqlCreateView view, QueryContext context) {
            String schemaPath = drillSchema.getFullSchemaName();
            String viewName = view.getName();
            Table table = SqlHandlerUtil.getTableFromSchema(drillSchema, viewName);
            boolean isTable = table != null && table.getJdbcTableType() != Schema.TableType.VIEW || context.getSession().isTemporaryTable(drillSchema, context.getConfig(), viewName);
            boolean isView = table != null && table.getJdbcTableType() == Schema.TableType.VIEW;
            switch (view.getSqlCreateType()) {
                case SIMPLE: {
                    if (isTable) {
                        throw UserException.validationError().message("A non-view table with given name [%s] already exists in schema [%s]", viewName, schemaPath).build(logger);
                    }
                    if (!isView) break;
                    throw UserException.validationError().message("A view with given name [%s] already exists in schema [%s]", viewName, schemaPath).build(logger);
                }
                case OR_REPLACE: {
                    if (!isTable) break;
                    throw UserException.validationError().message("A non-view table with given name [%s] already exists in schema [%s]", viewName, schemaPath).build(logger);
                }
                case IF_NOT_EXISTS: {
                    if (!isTable && !isView) break;
                    return false;
                }
            }
            return true;
        }
    }
}

