/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlHandlerUtil {
    private static final Logger logger = LoggerFactory.getLogger(SqlHandlerUtil.class);

    public static RelNode resolveNewTableRel(boolean isNewTableView, List<String> tableFieldNames, RelDataType validatedRowtype, RelNode queryRelNode) throws ValidationException, RelConversionException {
        if (tableFieldNames.size() > 0) {
            if (tableFieldNames.size() != validatedRowtype.getFieldCount()) {
                String tblType = isNewTableView ? "view" : "table";
                throw UserException.validationError().message("%s's field list and the %s's query field list have different counts.", tblType, tblType).build(logger);
            }
            for (String field : validatedRowtype.getFieldNames()) {
                if (!"**".equals(field)) continue;
                String tblType = isNewTableView ? "view" : "table";
                throw UserException.validationError().message("%s's query field list has a '*', which is invalid when %s's field list is specified.", tblType, tblType).build(logger);
            }
            SqlHandlerUtil.ensureNoDuplicateColumnNames(tableFieldNames);
            return DrillRelOptUtil.createRename(queryRelNode, tableFieldNames);
        }
        SqlHandlerUtil.ensureNoDuplicateColumnNames(validatedRowtype.getFieldNames());
        return queryRelNode;
    }

    private static void ensureNoDuplicateColumnNames(List<String> fieldNames) throws ValidationException {
        HashSet<String> fieldHashSet = Sets.newHashSetWithExpectedSize(fieldNames.size());
        for (String field : fieldNames) {
            if (fieldHashSet.contains(field.toLowerCase())) {
                throw new ValidationException(String.format("Duplicate column name [%s]", field));
            }
            fieldHashSet.add(field.toLowerCase());
        }
    }

    public static RelNode qualifyPartitionCol(RelNode input, List<String> partitionColumns) {
        final RelDataType inputRowType = input.getRowType();
        final ArrayList<RexNode> colRefStarExprs = Lists.newArrayList();
        final ArrayList<String> colRefStarNames = Lists.newArrayList();
        RexBuilder builder = input.getCluster().getRexBuilder();
        final int originalFieldSize = inputRowType.getFieldCount();
        for (String col : partitionColumns) {
            RelDataTypeField field = inputRowType.getField(col, false, false);
            if (field == null) {
                throw UserException.validationError().message("Partition column %s is not in the SELECT list of CTAS!", col).build(logger);
            }
            if (!"**".equals(field.getName())) continue;
            colRefStarNames.add(col);
            ArrayList<Object> operands = Lists.newArrayList();
            operands.add(new RexInputRef(field.getIndex(), field.getType()));
            operands.add(builder.makeLiteral(col));
            RexNode item = builder.makeCall(SqlStdOperatorTable.ITEM, operands);
            colRefStarExprs.add(item);
        }
        if (colRefStarExprs.isEmpty()) {
            return input;
        }
        AbstractList<String> names = new AbstractList<String>(){

            @Override
            public String get(int index) {
                if (index < originalFieldSize) {
                    return (String)inputRowType.getFieldNames().get(index);
                }
                return (String)colRefStarNames.get(index - originalFieldSize);
            }

            @Override
            public int size() {
                return originalFieldSize + colRefStarExprs.size();
            }
        };
        AbstractList<RexNode> refs = new AbstractList<RexNode>(){

            @Override
            public int size() {
                return originalFieldSize + colRefStarExprs.size();
            }

            @Override
            public RexNode get(int index) {
                if (index < originalFieldSize) {
                    return RexInputRef.of((int)index, (List)inputRowType.getFieldList());
                }
                return (RexNode)colRefStarExprs.get(index - originalFieldSize);
            }
        };
        return DrillRelFactories.LOGICAL_BUILDER.create(input.getCluster(), null).push(input).projectNamed((Iterable)refs, (Iterable)names, true).build();
    }

    public static Table getTableFromSchema(AbstractSchema drillSchema, String tblName) {
        try {
            return drillSchema.getTable(tblName);
        }
        catch (Exception e) {
            throw new DrillRuntimeException(String.format("Failure while trying to check if a table or view with given name [%s] already exists in schema [%s]: %s", tblName, drillSchema.getFullSchemaName(), e.getMessage()), e);
        }
    }

    public static void unparseSqlNodeList(SqlWriter writer, int leftPrec, int rightPrec, SqlNodeList fieldList) {
        writer.keyword("(");
        fieldList.get(0).unparse(writer, leftPrec, rightPrec);
        for (int i = 1; i < fieldList.size(); ++i) {
            writer.keyword(",");
            fieldList.get(i).unparse(writer, leftPrec, rightPrec);
        }
        writer.keyword(")");
    }

    public static void dropTableFromSchema(AbstractSchema drillSchema, String tableName) {
        block2: {
            try {
                drillSchema.dropTable(tableName);
            }
            catch (Exception e) {
                if (SqlHandlerUtil.getTableFromSchema(drillSchema, tableName) == null) break block2;
                throw e;
            }
        }
    }

    public static void dropViewFromSchema(AbstractSchema drillSchema, String viewName) throws IOException {
        block2: {
            try {
                drillSchema.dropView(viewName);
            }
            catch (Exception e) {
                if (SqlHandlerUtil.getTableFromSchema(drillSchema, viewName) == null) break block2;
                throw e;
            }
        }
    }

    public static void unparseKeyValuePairs(SqlWriter writer, int leftPrec, int rightPrec, SqlNodeList list) {
        writer.keyword("(");
        for (int i = 1; i < list.size(); i += 2) {
            if (i != 1) {
                writer.keyword(",");
            }
            list.get(i - 1).unparse(writer, leftPrec, rightPrec);
            writer.keyword("=");
            list.get(i).unparse(writer, leftPrec, rightPrec);
        }
        writer.keyword(")");
    }
}

