/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Util;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.SqlSelectBuilder;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillParserUtil;
import org.apache.drill.exec.planner.sql.parser.SqlShowTables;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.ischema.InfoSchemaTableType;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowTablesHandler
extends DefaultSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(ShowTablesHandler.class);

    public ShowTablesHandler(SqlHandlerConfig config) {
        super(config);
    }

    @Override
    public SqlNode rewrite(SqlNode sqlNode) throws ForemanSetupException {
        SchemaPlus schemaPlus;
        SqlShowTables node = ShowTablesHandler.unwrap(sqlNode, SqlShowTables.class);
        List<SqlNode> selectList = Arrays.asList(new SqlIdentifier("TABLE_SCHEMA", SqlParserPos.ZERO), new SqlIdentifier("TABLE_NAME", SqlParserPos.ZERO));
        SqlIdentifier fromClause = new SqlIdentifier(Arrays.asList("information_schema", InfoSchemaTableType.TABLES.name()), SqlParserPos.ZERO);
        if (node.getDb() != null) {
            ImmutableList schemaNames = node.getDb().names;
            schemaPlus = SchemaUtilities.findSchema(this.config.getConverter().getDefaultSchema(), schemaNames);
            if (schemaPlus == null) {
                throw UserException.validationError().message("Invalid schema name [%s]", SchemaUtilities.getSchemaPath(schemaNames)).build(logger);
            }
        } else {
            schemaPlus = this.config.getConverter().getDefaultSchema();
        }
        if (SchemaUtilities.isRootSchema(schemaPlus)) {
            throw UserException.validationError().message("No default schema selected. Select a schema using 'USE schema' command", new Object[0]).build(logger);
        }
        AbstractSchema drillSchema = SchemaUtilities.unwrapAsDrillSchemaInstance(schemaPlus);
        SqlNode where = DrillParserUtil.createCondition((SqlNode)new SqlIdentifier("TABLE_SCHEMA", SqlParserPos.ZERO), (SqlOperator)SqlStdOperatorTable.EQUALS, (SqlNode)SqlLiteral.createCharString((String)drillSchema.getFullSchemaName(), (String)Util.getDefaultCharset().name(), (SqlParserPos)SqlParserPos.ZERO));
        SqlNode filter = null;
        if (node.getLikePattern() != null) {
            SqlNode likePattern = node.getLikePattern();
            SqlIdentifier column = new SqlIdentifier("TABLE_NAME", SqlParserPos.ZERO);
            if (!drillSchema.areTableNamesCaseSensitive() && likePattern instanceof SqlCharStringLiteral) {
                NlsString conditionString = ((SqlCharStringLiteral)likePattern).getNlsString();
                likePattern = SqlCharStringLiteral.createCharString((String)conditionString.getValue().toLowerCase(), (String)conditionString.getCharsetName(), (SqlParserPos)likePattern.getParserPosition());
                column = SqlStdOperatorTable.LOWER.createCall(SqlParserPos.ZERO, new SqlNode[]{column});
            }
            filter = DrillParserUtil.createCondition((SqlNode)column, (SqlOperator)SqlStdOperatorTable.LIKE, likePattern);
        } else if (node.getWhereClause() != null) {
            filter = node.getWhereClause();
        }
        where = DrillParserUtil.createCondition(where, (SqlOperator)SqlStdOperatorTable.AND, filter);
        return new SqlSelectBuilder().parserPosition(SqlParserPos.ZERO).selectList(new SqlNodeList(selectList, SqlParserPos.ZERO)).from((SqlNode)fromClause).where(where).build();
    }

    @Override
    protected DefaultSqlHandler.ConvertedRelNode validateAndConvert(SqlNode sqlNode) throws ForemanSetupException, RelConversionException, ValidationException {
        try {
            this.config.getConverter().useRootSchemaAsDefault(true);
            DefaultSqlHandler.ConvertedRelNode convertedRelNode = super.validateAndConvert(sqlNode);
            return convertedRelNode;
        }
        finally {
            this.config.getConverter().useRootSchemaAsDefault(false);
        }
    }
}

