/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.NlsString;
import org.apache.drill.exec.planner.sql.SqlSelectBuilder;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillParserUtil;
import org.apache.drill.exec.planner.sql.parser.SqlShowSchemas;
import org.apache.drill.exec.store.ischema.InfoSchemaTableType;
import org.apache.drill.exec.work.foreman.ForemanSetupException;

public class ShowSchemasHandler
extends DefaultSqlHandler {
    public ShowSchemasHandler(SqlHandlerConfig config) {
        super(config);
    }

    @Override
    public SqlNode rewrite(SqlNode sqlNode) throws ForemanSetupException {
        SqlShowSchemas node = ShowSchemasHandler.unwrap(sqlNode, SqlShowSchemas.class);
        List<SqlIdentifier> selectList = Collections.singletonList(new SqlIdentifier("SCHEMA_NAME", SqlParserPos.ZERO));
        SqlIdentifier fromClause = new SqlIdentifier(Arrays.asList("information_schema", InfoSchemaTableType.SCHEMATA.name()), SqlParserPos.ZERO);
        SqlNode where = null;
        SqlNode likePattern = node.getLikePattern();
        if (likePattern != null) {
            SqlIdentifier column = new SqlIdentifier("SCHEMA_NAME", SqlParserPos.ZERO);
            if (likePattern instanceof SqlCharStringLiteral) {
                NlsString conditionString = ((SqlCharStringLiteral)likePattern).getNlsString();
                likePattern = SqlCharStringLiteral.createCharString((String)conditionString.getValue().toLowerCase(), (String)conditionString.getCharsetName(), (SqlParserPos)likePattern.getParserPosition());
                column = SqlStdOperatorTable.LOWER.createCall(SqlParserPos.ZERO, new SqlNode[]{column});
            }
            where = DrillParserUtil.createCondition((SqlNode)column, (SqlOperator)SqlStdOperatorTable.LIKE, likePattern);
        } else if (node.getWhereClause() != null) {
            where = node.getWhereClause();
        }
        return new SqlSelectBuilder().parserPosition(SqlParserPos.ZERO).selectList(new SqlNodeList(selectList, SqlParserPos.ZERO)).from((SqlNode)fromClause).where(where).build();
    }
}

