/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.math.BigDecimal;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSetOption;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlSetHandler;
import org.apache.drill.exec.server.options.OptionDefinition;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetOptionHandler
extends AbstractSqlSetHandler {
    private static final Logger logger = LoggerFactory.getLogger(SetOptionHandler.class);

    public SetOptionHandler(QueryContext context) {
        super(context);
    }

    @Override
    public final PhysicalPlan getPlan(SqlNode sqlNode) throws ForemanSetupException {
        SqlSetOption statement = SetOptionHandler.unwrap(sqlNode, SqlSetOption.class);
        OptionValue.OptionScope optionScope = this.getScope(statement, this.context.getOptions());
        OptionManager optionManager = this.context.getOptions().getOptionManager(optionScope);
        String optionName = statement.getName().toString();
        SqlNode optionValue = statement.getValue();
        if (optionValue == null) {
            OptionDefinition optionDefinition = optionManager.getOptionDefinition(optionName);
            String value = String.valueOf(optionManager.getOption(optionName).getValue());
            return DirectPlan.createDirectPlan(this.context, new SetOptionViewResult(optionDefinition.getValidator().getOptionName(), value));
        }
        if (optionScope == OptionValue.OptionScope.SYSTEM) {
            this.checkAdminPrivileges(this.context.getOptions());
        }
        if (!(optionValue instanceof SqlLiteral)) {
            throw UserException.validationError().message("Drill does not support assigning non-literal values in SET statements.", new Object[0]).build(logger);
        }
        optionManager.setLocalOption(optionName, SetOptionHandler.sqlLiteralToObject((SqlLiteral)optionValue));
        return DirectPlan.createDirectPlan(this.context, true, String.format("%s updated.", optionName));
    }

    private static Object sqlLiteralToObject(SqlLiteral literal) {
        Object object = literal.getValue();
        SqlTypeName typeName = literal.getTypeName();
        switch (typeName) {
            case DECIMAL: {
                BigDecimal bigDecimal = (BigDecimal)object;
                if (bigDecimal.scale() == 0) {
                    return bigDecimal.longValue();
                }
                return bigDecimal.doubleValue();
            }
            case DOUBLE: 
            case FLOAT: {
                return ((BigDecimal)object).doubleValue();
            }
            case SMALLINT: 
            case TINYINT: 
            case BIGINT: 
            case INTEGER: {
                return ((BigDecimal)object).longValue();
            }
            case VARBINARY: 
            case VARCHAR: 
            case CHAR: {
                return ((NlsString)object).getValue();
            }
            case BOOLEAN: {
                return object;
            }
        }
        throw UserException.validationError().message("Drill doesn't support assigning literals of type %s in SET statements.", typeName).build(logger);
    }

    public static class SetOptionViewResult {
        public String name;
        public String value;

        SetOptionViewResult(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

