/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSetOption;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlSetHandler;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.options.QueryOptionManager;
import org.apache.drill.exec.work.foreman.ForemanSetupException;

public class ResetOptionHandler
extends AbstractSqlSetHandler {
    public ResetOptionHandler(QueryContext context) {
        super(context);
    }

    @Override
    public final PhysicalPlan getPlan(SqlNode sqlNode) throws ForemanSetupException {
        QueryOptionManager options = this.context.getOptions();
        SqlSetOption statement = ResetOptionHandler.unwrap(sqlNode, SqlSetOption.class);
        OptionValue.OptionScope optionScope = this.getScope(statement, this.context.getOptions());
        if (optionScope == OptionValue.OptionScope.SYSTEM) {
            this.checkAdminPrivileges(options);
        }
        OptionManager optionManager = options.getOptionManager(optionScope);
        String optionName = statement.getName().toString();
        if ("ALL".equalsIgnoreCase(optionName)) {
            optionManager.deleteAllLocalOptions();
        } else {
            optionManager.deleteLocalOption(optionName);
        }
        return DirectPlan.createDirectPlan(this.context, true, String.format("%s updated.", optionName));
    }
}

