/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.SqlRefreshMetadata;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.dfs.NamedFormatPluginConfig;
import org.apache.drill.exec.store.parquet.ParquetFormatConfig;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.metadata.Metadata;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshMetadataHandler
extends DefaultSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(RefreshMetadataHandler.class);

    public RefreshMetadataHandler(SqlHandlerConfig config) {
        super(config);
    }

    private PhysicalPlan direct(boolean outcome, String message, Object ... values) {
        return DirectPlan.createDirectPlan(this.context, outcome, String.format(message, values));
    }

    private PhysicalPlan notSupported(String tbl) {
        return this.direct(false, "Table %s does not support metadata refresh. Support is currently limited to directory-based Parquet tables.", tbl);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ForemanSetupException {
        SqlRefreshMetadata refreshTable = RefreshMetadataHandler.unwrap(sqlNode, SqlRefreshMetadata.class);
        try {
            Path selectionRoot;
            SchemaPlus schema = SchemaUtilities.findSchema(this.config.getConverter().getDefaultSchema(), refreshTable.getSchemaPath());
            if (schema == null) {
                return this.direct(false, "Storage plugin or workspace does not exist [%s]", SchemaUtilities.SCHEMA_PATH_JOINER.join(refreshTable.getSchemaPath()));
            }
            String tableName = refreshTable.getName();
            SqlNodeList columnList = this.getColumnList(refreshTable);
            Set<SchemaPath> columnSet = this.getColumnRootSegments(columnList);
            SqlLiteral allColumns = refreshTable.getAllColumns();
            if (tableName.contains("*") || tableName.contains("?")) {
                return this.direct(false, "Glob path %s not supported for metadata refresh", tableName);
            }
            Table table = schema.getTable(tableName);
            if (table == null) {
                return this.direct(false, "Table %s does not exist.", tableName);
            }
            if (!(table instanceof DrillTable)) {
                return this.notSupported(tableName);
            }
            DrillTable drillTable = (DrillTable)table;
            Object selection = drillTable.getSelection();
            if (selection instanceof FileSelection && ((FileSelection)selection).isEmptyDirectory()) {
                return this.direct(false, "Table %s is empty and doesn't contain any parquet files.", tableName);
            }
            if (!(selection instanceof FormatSelection)) {
                return this.notSupported(tableName);
            }
            FormatSelection formatSelection = (FormatSelection)selection;
            FormatPluginConfig formatConfig = formatSelection.getFormat();
            if (!(formatConfig instanceof ParquetFormatConfig || formatConfig instanceof NamedFormatPluginConfig && ((NamedFormatPluginConfig)formatConfig).getName().equals("parquet"))) {
                return this.notSupported(tableName);
            }
            DrillFileSystem fs = ImpersonationUtil.createFileSystem(ImpersonationUtil.getProcessUserName(), drillTable.getPlugin().getFormatPlugin(formatConfig).getFsConf());
            if (!fs.getFileStatus(selectionRoot = formatSelection.getSelection().getSelectionRoot()).isDirectory()) {
                return this.notSupported(tableName);
            }
            if (!(formatConfig instanceof ParquetFormatConfig)) {
                formatConfig = new ParquetFormatConfig();
            }
            ParquetReaderConfig readerConfig = ParquetReaderConfig.builder().withFormatConfig((ParquetFormatConfig)formatConfig).withOptions(this.context.getOptions()).build();
            Metadata.createMeta(fs, selectionRoot, readerConfig, allColumns.booleanValue(), columnSet);
            return this.direct(true, "Successfully updated metadata for table %s.", tableName);
        }
        catch (Exception e) {
            logger.error("Failed to update metadata for table '{}'", (Object)refreshTable.getName(), (Object)e);
            return DirectPlan.createDirectPlan(this.context, false, String.format("Error: %s", e.getMessage()));
        }
    }

    private Set<SchemaPath> getColumnRootSegments(SqlNodeList columnList) {
        HashSet<SchemaPath> columnSet = new HashSet<SchemaPath>();
        if (columnList != null) {
            for (SqlNode column : columnList.getList()) {
                columnSet.add(SchemaPath.getSimplePath(SchemaPath.parseFromString(column.toSqlString(null, true).getSql()).getRootSegmentPath()));
            }
        }
        return columnSet;
    }

    private SqlNodeList getColumnList(SqlRefreshMetadata sqlrefreshMetadata) {
        SqlNodeList columnList = sqlrefreshMetadata.getFieldList();
        if (SqlNodeList.isEmptyList((SqlNode)columnList)) {
            columnList = new SqlNodeList(SqlParserPos.ZERO);
            columnList.add((SqlNode)new SqlIdentifier(SchemaPath.STAR_COLUMN.rootName(), SqlParserPos.ZERO));
        }
        return columnList;
    }
}

