/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.util.function.CheckedSupplier;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.metastore.ColumnNamesOptions;
import org.apache.drill.exec.metastore.analyze.AnalyzeInfoProvider;
import org.apache.drill.exec.metastore.analyze.MetadataAggregateContext;
import org.apache.drill.exec.metastore.analyze.MetadataControllerContext;
import org.apache.drill.exec.metastore.analyze.MetadataHandlerContext;
import org.apache.drill.exec.metastore.analyze.MetadataInfoCollector;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillAnalyzeRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.DrillScreenRel;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.MetadataAggRel;
import org.apache.drill.exec.planner.logical.MetadataControllerRel;
import org.apache.drill.exec.planner.logical.MetadataHandlerRel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.sql.SqlSelectBuilder;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.DrillTableInfo;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.SqlMetastoreAnalyzeTable;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.metastore.components.tables.BasicTablesRequests;
import org.apache.drill.metastore.components.tables.MetastoreTableInfo;
import org.apache.drill.metastore.exceptions.MetastoreException;
import org.apache.drill.metastore.metadata.MetadataInfo;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.drill.shaded.guava.com.google.common.collect.ArrayListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.Multimap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreAnalyzeTableHandler
extends DefaultSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(MetastoreAnalyzeTableHandler.class);

    public MetastoreAnalyzeTableHandler(SqlHandlerConfig config, Pointer<String> textPlan) {
        super(config, textPlan);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ValidationException, RelConversionException, IOException, ForemanSetupException {
        if (!this.context.getOptions().getOption(ExecConstants.METASTORE_ENABLED_VALIDATOR)) {
            throw UserException.validationError().message("Running ANALYZE TABLE REFRESH METADATA command when Metastore is disabled (`metastore.enabled` is set to false)", new Object[0]).build(logger);
        }
        this.context.getOptions().setLocalOption("metastore.enabled", false);
        SqlMetastoreAnalyzeTable sqlAnalyzeTable = MetastoreAnalyzeTableHandler.unwrap(sqlNode, SqlMetastoreAnalyzeTable.class);
        SqlNode tableRef = sqlAnalyzeTable.getTableRef();
        DrillTableInfo drillTableInfo = DrillTableInfo.getTableInfoHolder(tableRef, this.config);
        AnalyzeInfoProvider analyzeInfoProvider = drillTableInfo.drillTable().getGroupScan().getAnalyzeInfoProvider();
        if (analyzeInfoProvider == null) {
            throw UserException.validationError().message("ANALYZE is not supported for group scan [%s]", drillTableInfo.drillTable().getGroupScan()).build(logger);
        }
        ColumnNamesOptions columnNamesOptions = new ColumnNamesOptions(this.context.getOptions());
        SqlSelect scanSql = new SqlSelectBuilder().parserPosition(SqlParserPos.ZERO).keywordList(SqlNodeList.EMPTY).selectList(this.getColumnList(analyzeInfoProvider.getProjectionFields(drillTableInfo.drillTable(), this.getMetadataType(sqlAnalyzeTable), columnNamesOptions))).from(tableRef).build();
        DefaultSqlHandler.ConvertedRelNode convertedRelNode = this.validateAndConvert(this.rewrite((SqlNode)scanSql));
        RelDataType validatedRowType = convertedRelNode.getValidatedRowType();
        RelNode relScan = convertedRelNode.getConvertedNode();
        DrillRel drel = this.convertToDrel(relScan, sqlAnalyzeTable, drillTableInfo);
        Prel prel = this.convertToPrel(drel, validatedRowType);
        this.logAndSetTextPlan("Drill Physical", prel, logger);
        PhysicalOperator pop = this.convertToPop(prel);
        PhysicalPlan plan = this.convertToPlan(pop, relScan);
        this.log("Drill Plan", plan, logger);
        return plan;
    }

    private SqlNodeList getColumnList(List<SchemaPath> projectingColumns) {
        SqlNodeList columnList = new SqlNodeList(SqlParserPos.ZERO);
        columnList.add((SqlNode)new SqlIdentifier("**", SqlParserPos.ZERO));
        projectingColumns.stream().map(segmentColumn -> new SqlIdentifier(segmentColumn.getRootSegmentPath(), SqlParserPos.ZERO)).forEach(arg_0 -> ((SqlNodeList)columnList).add(arg_0));
        return columnList;
    }

    private MetadataType getMetadataType(SqlMetastoreAnalyzeTable sqlAnalyzeTable) {
        SqlLiteral stringLiteral = sqlAnalyzeTable.getLevel();
        String metadataLevel = stringLiteral == null ? this.context.getOption((String)"metastore.metadata.store.depth_level").string_val : stringLiteral.toValue();
        return metadataLevel != null ? MetadataType.valueOf(metadataLevel.toUpperCase()) : MetadataType.ALL;
    }

    private DrillRel convertToDrel(RelNode relNode, SqlMetastoreAnalyzeTable sqlAnalyzeTable, DrillTableInfo drillTableInfo) throws ForemanSetupException, IOException {
        MetadataHandlerContext handlerContext;
        ArrayList<SchemaPath> statisticsColumns;
        BasicTablesRequests basicRequests;
        RelBuilder relBuilder = DrillRelFactories.LOGICAL_BUILDER.create(relNode.getCluster(), null);
        DrillTable table = drillTableInfo.drillTable();
        AnalyzeInfoProvider analyzeInfoProvider = table.getGroupScan().getAnalyzeInfoProvider();
        List<String> schemaPath = drillTableInfo.schemaPath();
        String pluginName = schemaPath.get(0);
        String workspaceName = String.join((CharSequence)".", schemaPath.subList(1, schemaPath.size()));
        String tableName = drillTableInfo.tableName();
        TableInfo tableInfo = TableInfo.builder().name(tableName).owner(table.getUserName()).type(analyzeInfoProvider.getTableTypeName()).storagePlugin(pluginName).workspace(workspaceName).build();
        ColumnNamesOptions columnNamesOptions = new ColumnNamesOptions(this.context.getOptions());
        List<String> segmentColumns = analyzeInfoProvider.getSegmentColumns(table, columnNamesOptions).stream().map(SchemaPath::getRootSegmentPath).collect(Collectors.toList());
        List<NamedExpression> segmentExpressions = segmentColumns.stream().map(partitionName -> new NamedExpression(SchemaPath.getSimplePath(partitionName), FieldReference.getWithQuotedRef(partitionName))).collect(Collectors.toList());
        List<MetadataInfo> rowGroupsInfo = Collections.emptyList();
        List<MetadataInfo> filesInfo = Collections.emptyList();
        Multimap<Object, Object> segments = ArrayListMultimap.create();
        try {
            basicRequests = this.context.getMetastoreRegistry().get().tables().basicRequests();
        }
        catch (MetastoreException e) {
            logger.error("Error when obtaining Metastore instance for table {}", (Object)tableName, (Object)e);
            DrillRel convertedRelNode = this.convertToRawDrel(relBuilder.values(new String[]{"ok", "summary"}, new Object[]{false, e.getMessage()}).build());
            return new DrillScreenRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode);
        }
        MetadataType metadataLevel = this.getMetadataType(sqlAnalyzeTable);
        List<SchemaPath> interestingColumns = sqlAnalyzeTable.getFieldNames();
        MetastoreTableInfo metastoreTableInfo = basicRequests.metastoreTableInfo(tableInfo);
        List<MetadataInfo> allMetaToHandle = null;
        ArrayList<MetadataInfo> metadataToRemove = new ArrayList();
        if (metastoreTableInfo.isExists()) {
            RelNode finalRelNode = relNode;
            CheckedSupplier tableScanSupplier = () -> DrillRelOptUtil.findScan(this.convertToDrel(finalRelNode.getInput(0)));
            MetadataInfoCollector metadataInfoCollector = analyzeInfoProvider.getMetadataInfoCollector(basicRequests, tableInfo, (FormatSelection)table.getSelection(), this.context.getPlannerSettings(), tableScanSupplier, interestingColumns, metadataLevel, segmentColumns.size());
            if (!metadataInfoCollector.isOutdated()) {
                DrillRel convertedRelNode = this.convertToRawDrel(relBuilder.values(new String[]{"ok", "summary"}, new Object[]{false, "Table metadata is up to date, analyze wasn't performed."}).build());
                return new DrillScreenRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode);
            }
            relNode = relNode.copy(relNode.getTraitSet(), Collections.singletonList(metadataInfoCollector.getPrunedScan()));
            filesInfo = metadataInfoCollector.getFilesInfo();
            segments = metadataInfoCollector.getSegmentsInfo();
            rowGroupsInfo = metadataInfoCollector.getRowGroupsInfo();
            allMetaToHandle = metadataInfoCollector.getAllMetaToHandle();
            metadataToRemove = metadataInfoCollector.getMetadataToRemove();
        }
        DrillRel convertedRelNode = this.convertToRawDrel(relNode);
        boolean createNewAggregations = true;
        ArrayList<SchemaPath> arrayList = statisticsColumns = interestingColumns == null ? null : new ArrayList<SchemaPath>(interestingColumns);
        if (statisticsColumns != null) {
            segmentColumns.stream().map(SchemaPath::getSimplePath).forEach(statisticsColumns::add);
        }
        SchemaPath locationField = analyzeInfoProvider.getLocationField(columnNamesOptions);
        if (analyzeInfoProvider.supportsMetadataType(MetadataType.ROW_GROUP) && metadataLevel.includes(MetadataType.ROW_GROUP)) {
            handlerContext = MetadataHandlerContext.builder().tableInfo(tableInfo).metadataToHandle(rowGroupsInfo).metadataType(MetadataType.ROW_GROUP).depthLevel(segmentExpressions.size()).segmentColumns(segmentColumns).build();
            convertedRelNode = this.getRowGroupAggRelNode(segmentExpressions, convertedRelNode, createNewAggregations, statisticsColumns, handlerContext);
            createNewAggregations = false;
            locationField = SchemaPath.getSimplePath("location");
        }
        if (analyzeInfoProvider.supportsMetadataType(MetadataType.FILE) && metadataLevel.includes(MetadataType.FILE)) {
            handlerContext = MetadataHandlerContext.builder().tableInfo(tableInfo).metadataToHandle(filesInfo).metadataType(MetadataType.FILE).depthLevel(segmentExpressions.size()).segmentColumns(segmentColumns).build();
            convertedRelNode = this.getFileAggRelNode(segmentExpressions, convertedRelNode, createNewAggregations, statisticsColumns, locationField, handlerContext);
            locationField = SchemaPath.getSimplePath("location");
            createNewAggregations = false;
        }
        if (analyzeInfoProvider.supportsMetadataType(MetadataType.SEGMENT) && metadataLevel.includes(MetadataType.SEGMENT)) {
            for (int i = segmentExpressions.size(); i > 0; --i) {
                MetadataHandlerContext handlerContext2 = MetadataHandlerContext.builder().tableInfo(tableInfo).metadataToHandle(new ArrayList<Object>(segments.get(i - 1))).metadataType(MetadataType.SEGMENT).depthLevel(i).segmentColumns(segmentColumns.subList(0, i)).build();
                convertedRelNode = this.getSegmentAggRelNode(segmentExpressions, convertedRelNode, createNewAggregations, statisticsColumns, locationField, i, handlerContext2);
                locationField = SchemaPath.getSimplePath("location");
                createNewAggregations = false;
            }
        }
        if (!analyzeInfoProvider.supportsMetadataType(MetadataType.TABLE) || !metadataLevel.includes(MetadataType.TABLE)) {
            throw new IllegalStateException("Analyze table with NONE level");
        }
        MetadataHandlerContext handlerContext3 = MetadataHandlerContext.builder().tableInfo(tableInfo).metadataToHandle(Collections.emptyList()).metadataType(MetadataType.TABLE).depthLevel(segmentExpressions.size()).segmentColumns(segmentColumns).build();
        convertedRelNode = this.getTableAggRelNode(convertedRelNode, createNewAggregations, statisticsColumns, locationField, handlerContext3);
        boolean useStatistics = this.context.getOptions().getOption(PlannerSettings.STATISTICS_USE);
        SqlNumericLiteral samplePercentLiteral = sqlAnalyzeTable.getSamplePercent();
        double samplePercent = samplePercentLiteral == null ? 100.0 : (double)samplePercentLiteral.intValue(true);
        DrillRel analyzeRel = useStatistics ? new DrillAnalyzeRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), this.convertToRawDrel(relNode), samplePercent) : this.convertToRawDrel(relBuilder.values(convertedRelNode.getRowType()).build());
        MetadataControllerContext metadataControllerContext = MetadataControllerContext.builder().tableInfo(tableInfo).metastoreTableInfo(metastoreTableInfo).location(((FormatSelection)table.getSelection()).getSelection().getSelectionRoot()).interestingColumns(interestingColumns).segmentColumns(segmentColumns).metadataToHandle(allMetaToHandle).metadataToRemove(metadataToRemove).analyzeMetadataLevel(metadataLevel).build();
        convertedRelNode = new MetadataControllerRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode, analyzeRel, metadataControllerContext);
        return new DrillScreenRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode);
    }

    private DrillRel getTableAggRelNode(DrillRel convertedRelNode, boolean createNewAggregations, List<SchemaPath> statisticsColumns, SchemaPath locationField, MetadataHandlerContext handlerContext) {
        SchemaPath lastModifiedTimeField = SchemaPath.getSimplePath(this.config.getContext().getOptions().getString("drill.exec.storage.implicit.last_modified_time.column.label"));
        List<SchemaPath> metadataColumns = Arrays.asList(locationField, lastModifiedTimeField);
        MetadataAggregateContext aggregateContext = MetadataAggregateContext.builder().groupByExpressions(Collections.emptyList()).interestingColumns(statisticsColumns).createNewAggregations(createNewAggregations).metadataColumns(metadataColumns).metadataLevel(MetadataType.TABLE).build();
        convertedRelNode = new MetadataAggRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode, aggregateContext);
        convertedRelNode = new MetadataHandlerRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode, handlerContext);
        return convertedRelNode;
    }

    private DrillRel getSegmentAggRelNode(List<NamedExpression> segmentExpressions, DrillRel convertedRelNode, boolean createNewAggregations, List<SchemaPath> statisticsColumns, SchemaPath locationField, int segmentLevel, MetadataHandlerContext handlerContext) {
        SchemaPath lastModifiedTimeField = SchemaPath.getSimplePath(this.config.getContext().getOptions().getString("drill.exec.storage.implicit.last_modified_time.column.label"));
        List<SchemaPath> metadataColumns = Arrays.asList(lastModifiedTimeField, locationField);
        ArrayList<NamedExpression> groupByExpressions = new ArrayList<NamedExpression>(segmentExpressions);
        MetadataAggregateContext aggregateContext = MetadataAggregateContext.builder().groupByExpressions(groupByExpressions.subList(0, segmentLevel)).interestingColumns(statisticsColumns).createNewAggregations(createNewAggregations).metadataColumns(metadataColumns).metadataLevel(MetadataType.SEGMENT).build();
        convertedRelNode = new MetadataAggRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode, aggregateContext);
        convertedRelNode = new MetadataHandlerRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode, handlerContext);
        return convertedRelNode;
    }

    private DrillRel getFileAggRelNode(List<NamedExpression> segmentExpressions, DrillRel convertedRelNode, boolean createNewAggregations, List<SchemaPath> statisticsColumns, SchemaPath locationField, MetadataHandlerContext handlerContext) {
        SchemaPath lastModifiedTimeField = SchemaPath.getSimplePath(this.config.getContext().getOptions().getString("drill.exec.storage.implicit.last_modified_time.column.label"));
        List<SchemaPath> metadataColumns = Arrays.asList(lastModifiedTimeField, locationField);
        NamedExpression locationExpression = new NamedExpression(locationField, FieldReference.getWithQuotedRef("location"));
        ArrayList<NamedExpression> fileGroupByExpressions = new ArrayList<NamedExpression>(segmentExpressions);
        fileGroupByExpressions.add(locationExpression);
        MetadataAggregateContext aggregateContext = MetadataAggregateContext.builder().groupByExpressions(fileGroupByExpressions).interestingColumns(statisticsColumns).createNewAggregations(createNewAggregations).metadataColumns(metadataColumns).metadataLevel(MetadataType.FILE).build();
        convertedRelNode = new MetadataAggRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode, aggregateContext);
        convertedRelNode = new MetadataHandlerRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode, handlerContext);
        return convertedRelNode;
    }

    private DrillRel getRowGroupAggRelNode(List<NamedExpression> segmentExpressions, DrillRel convertedRelNode, boolean createNewAggregations, List<SchemaPath> statisticsColumns, MetadataHandlerContext handlerContext) {
        SchemaPath locationField = SchemaPath.getSimplePath(this.config.getContext().getOptions().getString("drill.exec.storage.implicit.fqn.column.label"));
        SchemaPath lastModifiedTimeField = SchemaPath.getSimplePath(this.config.getContext().getOptions().getString("drill.exec.storage.implicit.last_modified_time.column.label"));
        String rowGroupIndexColumn = this.config.getContext().getOptions().getString("drill.exec.storage.implicit.row_group_index.column.label");
        SchemaPath rgiField = SchemaPath.getSimplePath(rowGroupIndexColumn);
        List<NamedExpression> rowGroupGroupByExpressions = this.getRowGroupExpressions(segmentExpressions, locationField, rowGroupIndexColumn, rgiField);
        SchemaPath rowGroupStartField = SchemaPath.getSimplePath(this.config.getContext().getOptions().getString("drill.exec.storage.implicit.row_group_start.column.label"));
        SchemaPath rowGroupLengthField = SchemaPath.getSimplePath(this.config.getContext().getOptions().getString("drill.exec.storage.implicit.row_group_length.column.label"));
        List<SchemaPath> metadataColumns = Arrays.asList(lastModifiedTimeField, locationField, rgiField, rowGroupStartField, rowGroupLengthField);
        MetadataAggregateContext aggregateContext = MetadataAggregateContext.builder().groupByExpressions(rowGroupGroupByExpressions).interestingColumns(statisticsColumns).createNewAggregations(createNewAggregations).metadataColumns(metadataColumns).metadataLevel(MetadataType.ROW_GROUP).build();
        convertedRelNode = new MetadataAggRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode, aggregateContext);
        convertedRelNode = new MetadataHandlerRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode, handlerContext);
        return convertedRelNode;
    }

    private List<NamedExpression> getRowGroupExpressions(List<NamedExpression> segmentExpressions, SchemaPath locationField, String rowGroupIndexColumn, SchemaPath rgiField) {
        ArrayList<NamedExpression> rowGroupGroupByExpressions = new ArrayList<NamedExpression>(segmentExpressions);
        rowGroupGroupByExpressions.add(new NamedExpression(locationField, FieldReference.getWithQuotedRef("location")));
        rowGroupGroupByExpressions.add(new NamedExpression(rgiField, FieldReference.getWithQuotedRef(rowGroupIndexColumn)));
        return rowGroupGroupByExpressions;
    }
}

