/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertHandler
extends DefaultSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(InsertHandler.class);

    public InsertHandler(SqlHandlerConfig config, Pointer<String> textPlan) {
        super(config, textPlan);
    }

    @Override
    protected DefaultSqlHandler.ConvertedRelNode validateAndConvert(SqlNode sqlNode) throws ForemanSetupException, RelConversionException, ValidationException {
        DefaultSqlHandler.ConvertedRelNode convertedRelNode = super.validateAndConvert(sqlNode);
        String storageName = SchemaUtilities.getSchemaPathAsList((String)convertedRelNode.getConvertedNode().getTable().getQualifiedName().iterator().next()).iterator().next();
        try {
            if (!this.context.getStorage().getPlugin(storageName).supportsInsert()) {
                throw UserException.validationError().message("Storage plugin [%s] is immutable or doesn't support inserts", storageName).build(logger);
            }
        }
        catch (StoragePluginRegistry.PluginException e) {
            throw new DrillRuntimeException(e);
        }
        return convertedRelNode;
    }
}

