/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.TableScan;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.planner.fragment.DistributionAffinity;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTranslatableTable;

class FindHardDistributionScans
extends RelShuttleImpl {
    private boolean contains;

    FindHardDistributionScans() {
    }

    public static boolean canForceSingleMode(RelNode relTree) {
        FindHardDistributionScans hdVisitor = new FindHardDistributionScans();
        relTree.accept((RelShuttle)hdVisitor);
        return !hdVisitor.contains();
    }

    public RelNode visit(TableScan scan) {
        DrillTable unwrap = (DrillTable)scan.getTable().unwrap(DrillTable.class);
        if (unwrap == null) {
            DrillTranslatableTable drillTranslatableTable = (DrillTranslatableTable)scan.getTable().unwrap(DrillTranslatableTable.class);
            if (drillTranslatableTable == null) {
                this.contains = true;
                return scan;
            }
            unwrap = drillTranslatableTable.getDrillTable();
        }
        try {
            if (unwrap.getGroupScan().getDistributionAffinity() == DistributionAffinity.HARD) {
                this.contains = true;
            }
        }
        catch (IOException e) {
            throw new DrillRuntimeException("Failed to get GroupScan from table.");
        }
        return scan;
    }

    public boolean contains() {
        return this.contains;
    }
}

