/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.explain.PrelSequencer;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplainHandler
extends DefaultSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExplainHandler.class);
    private PlanProperties.Generator.ResultMode mode;
    private SqlExplainLevel level = SqlExplainLevel.ALL_ATTRIBUTES;

    public ExplainHandler(SqlHandlerConfig config, Pointer<String> textPlan) {
        super(config, textPlan);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ValidationException, RelConversionException, IOException, ForemanSetupException {
        DefaultSqlHandler.ConvertedRelNode convertedRelNode = this.validateAndConvert(sqlNode);
        RelDataType validatedRowType = convertedRelNode.getValidatedRowType();
        RelNode queryRelNode = convertedRelNode.getConvertedNode();
        this.log("Calcite", queryRelNode, logger, null);
        DrillRel drel = this.convertToDrel(queryRelNode);
        if (this.mode == PlanProperties.Generator.ResultMode.LOGICAL) {
            LogicalExplain logicalResult = new LogicalExplain(drel, this.level, this.context);
            return DirectPlan.createDirectPlan(this.context, logicalResult);
        }
        Prel prel = this.convertToPrel(drel, validatedRowType);
        this.logAndSetTextPlan("Drill Physical", prel, logger);
        PhysicalOperator pop = this.convertToPop(prel);
        PhysicalPlan plan = this.convertToPlan(pop, queryRelNode);
        this.log("Drill Plan", plan, logger);
        PhysicalExplain physicalResult = new PhysicalExplain(prel, plan, this.level, this.context);
        return DirectPlan.createDirectPlan(this.context, physicalResult);
    }

    @Override
    public SqlNode rewrite(SqlNode sqlNode) throws RelConversionException, ForemanSetupException {
        SqlExplain node = ExplainHandler.unwrap(sqlNode, SqlExplain.class);
        SqlLiteral op = (SqlLiteral)node.operand(2);
        SqlExplain.Depth depth = (SqlExplain.Depth)op.getValue();
        if (node.getDetailLevel() != null) {
            this.level = node.getDetailLevel();
        }
        switch (depth) {
            case LOGICAL: {
                this.mode = PlanProperties.Generator.ResultMode.LOGICAL;
                break;
            }
            case PHYSICAL: {
                this.mode = PlanProperties.Generator.ResultMode.PHYSICAL;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown depth " + depth);
            }
        }
        return node.operand(0);
    }

    @VisibleForTesting
    public static void printPlan(Prel node, QueryContext context) {
        System.out.println(PrelSequencer.printWithIds(node, SqlExplainLevel.ALL_ATTRIBUTES));
    }

    @VisibleForTesting
    public static void printPlan(RelNode node) {
        System.out.println(RelOptUtil.toString((RelNode)node, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES));
    }

    public static class LogicalExplain {
        public final String text;
        public final String json;

        public LogicalExplain(RelNode node, SqlExplainLevel level, QueryContext context) {
            this.text = RelOptUtil.toString((RelNode)node, (SqlExplainLevel)level);
            DrillImplementor implementor = new DrillImplementor(new DrillParseContext(context.getPlannerSettings()), PlanProperties.Generator.ResultMode.LOGICAL);
            implementor.go((DrillRel)node);
            LogicalPlan plan = implementor.getPlan();
            this.json = plan.unparse(context.getLpPersistence());
        }
    }

    public static class PhysicalExplain {
        public final String text;
        public final String json;

        public PhysicalExplain(RelNode node, PhysicalPlan plan, SqlExplainLevel level, QueryContext context) {
            this.text = PrelSequencer.printWithIds((Prel)node, level);
            this.json = plan.unparse(context.getLpPersistence().getMapper().writer());
        }
    }
}

