/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.util.List;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlNode;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerUtil;
import org.apache.drill.exec.planner.sql.parser.SqlDropTable;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.store.AbstractSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTableHandler
extends DefaultSqlHandler {
    private static Logger logger = LoggerFactory.getLogger(DropTableHandler.class);

    public DropTableHandler(SqlHandlerConfig config) {
        super(config);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) {
        AbstractSchema temporarySchema;
        SqlDropTable dropTableNode = (SqlDropTable)sqlNode;
        String originalTableName = DrillStringUtils.removeLeadingSlash(dropTableNode.getName());
        SchemaPlus defaultSchema = this.config.getConverter().getDefaultSchema();
        List<String> tableSchema = dropTableNode.getSchema();
        DrillConfig drillConfig = this.context.getConfig();
        UserSession session = this.context.getSession();
        boolean isTemporaryTable = session.isTemporaryTable(temporarySchema = SchemaUtilities.resolveToTemporarySchema(tableSchema, defaultSchema, drillConfig), drillConfig, originalTableName);
        if (isTemporaryTable) {
            session.removeTemporaryTable(temporarySchema, originalTableName, drillConfig);
        } else {
            AbstractSchema drillSchema = SchemaUtilities.resolveToMutableDrillSchema(defaultSchema, tableSchema);
            Table tableToDrop = SqlHandlerUtil.getTableFromSchema(drillSchema, originalTableName);
            if (tableToDrop == null || tableToDrop.getJdbcTableType() != Schema.TableType.TABLE && tableToDrop.getJdbcTableType() != Schema.TableType.OTHER) {
                if (dropTableNode.checkTableExistence()) {
                    return DirectPlan.createDirectPlan(this.context, false, String.format("Table [%s] not found", originalTableName));
                }
                throw UserException.validationError().message("Table [%s] not found", originalTableName).build(logger);
            }
            SqlHandlerUtil.dropTableFromSchema(drillSchema, originalTableName);
        }
        String message = String.format("%s [%s] dropped", isTemporaryTable ? "Temporary table" : "Table", originalTableName);
        logger.info(message);
        return DirectPlan.createDirectPlan(this.context, true, message);
    }
}

