/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import java.util.Locale;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.alias.AliasRegistry;
import org.apache.drill.exec.alias.Aliases;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.BaseAliasHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.SqlDropAlias;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropAliasHandler
extends BaseAliasHandler {
    private static final Logger logger = LoggerFactory.getLogger(DropAliasHandler.class);

    public DropAliasHandler(SqlHandlerConfig config) {
        super(config);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ForemanSetupException, IOException {
        this.checkAliasesEnabled();
        SqlDropAlias node = DropAliasHandler.unwrap(sqlNode, SqlDropAlias.class);
        String alias = SchemaPath.getCompoundPath(node.getAlias().names.toArray(new String[0])).toExpr();
        String aliasTarget = ((SqlLiteral)node.getAliasKind()).toValue();
        AliasRegistry aliasRegistry = this.getAliasRegistry(aliasTarget);
        Aliases aliases = this.getAliases(node, aliasRegistry);
        boolean checkIfExists = ((SqlLiteral)node.getIfExists()).booleanValue();
        boolean removed = aliases.remove(alias);
        if (!removed && !checkIfExists) {
            throw UserException.validationError().message("No alias found with given name [%s]", alias).build(logger);
        }
        String message = removed ? String.format("%s alias '%s' dropped successfully", StringUtils.capitalize((String)aliasTarget.toLowerCase(Locale.ROOT)), alias) : String.format("No %s alias found with given name [%s]", aliasTarget.toLowerCase(Locale.ROOT), alias);
        return DirectPlan.createDirectPlan(this.context, removed, message);
    }

    private Aliases getAliases(SqlDropAlias dropAlias, AliasRegistry aliasRegistry) {
        boolean isPublicAlias = ((SqlLiteral)dropAlias.getIsPublic()).booleanValue();
        return isPublicAlias ? this.getPublicAliases(dropAlias, aliasRegistry) : this.getUserAliases(dropAlias, aliasRegistry);
    }

    private Aliases getUserAliases(SqlDropAlias dropAlias, AliasRegistry aliasRegistry) {
        if (!this.context.isImpersonationEnabled()) {
            throw UserException.validationError().message("Cannot drop user alias when user impersonation is disabled", new Object[0]).build(logger);
        }
        String userName = this.resolveUserName(dropAlias.getUser());
        return aliasRegistry.getUserAliases(userName);
    }

    private Aliases getPublicAliases(SqlDropAlias dropAlias, AliasRegistry aliasRegistry) {
        if (dropAlias.getUser() != null) {
            throw UserException.validationError().message("Cannot drop public alias for specific user", new Object[0]).build(logger);
        }
        this.checkAdminPrivileges(this.context.getOptions());
        return aliasRegistry.getPublicAliases();
    }
}

