/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.util.Optional;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.alias.AliasRegistry;
import org.apache.drill.exec.alias.AliasTarget;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.server.options.QueryOptionManager;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAliasHandler
extends DefaultSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(BaseAliasHandler.class);

    public BaseAliasHandler(SqlHandlerConfig config) {
        super(config);
    }

    protected void checkAliasesEnabled() {
        if (!this.context.getOptions().getBoolean("exec.enable_aliases")) {
            throw UserException.validationError().message("Aliases support is disabled.", new Object[0]).build(logger);
        }
    }

    protected void checkAdminPrivileges(QueryOptionManager options) {
        if (this.context.isUserAuthenticationEnabled() && !this.hasAdminPrivileges(options)) {
            throw UserException.permissionError().message("Not authorized to perform operations on public aliases.", new Object[0]).build(logger);
        }
    }

    protected boolean hasAdminPrivileges(QueryOptionManager options) {
        return ImpersonationUtil.hasAdminPrivileges(this.context.getQueryUserName(), ExecConstants.ADMIN_USERS_VALIDATOR.getAdminUsers(options), ExecConstants.ADMIN_USER_GROUPS_VALIDATOR.getAdminUserGroups(options));
    }

    protected String resolveUserName(SqlNode user) {
        String queryUserName = this.context.getQueryUserName();
        return Optional.ofNullable(user).map(SqlLiteral.class::cast).map(SqlLiteral::toValue).filter(provided -> !queryUserName.equals(provided)).map(provided -> {
            if (!this.hasAdminPrivileges(this.context.getOptions())) {
                throw UserException.permissionError().message("Not authorized to perform operations on aliases for other users.", new Object[0]).build(logger);
            }
            return provided;
        }).orElse(queryUserName);
    }

    protected AliasRegistry getAliasRegistry(String aliasTarget) {
        switch (AliasTarget.valueOf(aliasTarget)) {
            case TABLE: {
                return this.config.getContext().getAliasRegistryProvider().getTableAliasesRegistry();
            }
            case STORAGE: {
                return this.config.getContext().getAliasRegistryProvider().getStorageAliasesRegistry();
            }
        }
        throw UserException.validationError().message("Unsupported alias target: [%s]", aliasTarget).build(logger);
    }
}

