/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import org.apache.calcite.sql.SqlSetOption;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.options.QueryOptionManager;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSqlSetHandler
extends AbstractSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSqlSetHandler.class);
    final QueryContext context;

    AbstractSqlSetHandler(QueryContext context) {
        this.context = context;
    }

    OptionValue.OptionScope getScope(SqlSetOption statement, QueryOptionManager options) {
        String scope = statement.getScope();
        if (scope == null) {
            return OptionValue.OptionScope.SESSION;
        }
        switch (scope.toLowerCase()) {
            case "session": {
                if (options.getBoolean("exec.query_profile.alter_session.skip")) {
                    logger.debug("Will not write profile for ALTER SESSION SET ... ");
                    this.context.skipWritingProfile(true);
                }
                return OptionValue.OptionScope.SESSION;
            }
            case "system": {
                return OptionValue.OptionScope.SYSTEM;
            }
        }
        throw UserException.validationError().message("Invalid OPTION scope %s. Scope must be SESSION or SYSTEM.", scope).build(logger);
    }

    void checkAdminPrivileges(QueryOptionManager options) {
        if (this.context.isUserAuthenticationEnabled() && !ImpersonationUtil.hasAdminPrivileges(this.context.getQueryUserName(), ExecConstants.ADMIN_USERS_VALIDATOR.getAdminUsers(options), ExecConstants.ADMIN_USER_GROUPS_VALIDATOR.getAdminUserGroups(options))) {
            throw UserException.permissionError().message("Not authorized to change SYSTEM options.", new Object[0]).build(logger);
        }
    }
}

