/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.conversion;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.jdbc.DynamicSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.logical.DrillConstExecutor;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.sql.DrillConformance;
import org.apache.drill.exec.planner.sql.DrillConvertletTable;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.conversion.DrillCalciteCatalogReader;
import org.apache.drill.exec.planner.sql.conversion.DrillRexBuilder;
import org.apache.drill.exec.planner.sql.conversion.DrillViewExpander;
import org.apache.drill.exec.planner.sql.parser.impl.DrillParserWithCompoundIdConverter;
import org.apache.drill.exec.planner.sql.parser.impl.DrillSqlParseException;
import org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.exec.util.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlConverter {
    private static final Logger logger = LoggerFactory.getLogger(SqlConverter.class);
    public static final SqlConformance DRILL_CONFORMANCE = new DrillConformance();
    private final JavaTypeFactory typeFactory;
    private final SqlParser.Config parserConfig;
    private final DrillCalciteCatalogReader catalog;
    private final PlannerSettings settings;
    private final SchemaPlus rootSchema;
    private final SchemaPlus defaultSchema;
    private final SqlOperatorTable opTab;
    private final RelOptCostFactory costFactory;
    private final SqlValidator validator;
    private final boolean isInnerQuery;
    private final boolean isExpandedView;
    private final QueryContext util;
    private final FunctionImplementationRegistry functions;
    private final String temporarySchema;
    private final UserSession session;
    private final DrillConfig drillConfig;
    private final SqlToRelConverter.Config sqlToRelConverterConfig;
    private RelOptCluster cluster;
    private VolcanoPlanner planner;
    private boolean useRootSchema = false;
    private final boolean isImpersonationEnabled;

    public SqlConverter(QueryContext context) {
        this.settings = context.getPlannerSettings();
        this.util = context;
        this.functions = context.getFunctionRegistry();
        this.parserConfig = SqlParser.Config.DEFAULT.withIdentifierMaxLength((int)this.settings.getIdentifierMaxLength()).withQuoting(this.settings.getQuotingIdentifiers()).withParserFactory(DrillParserWithCompoundIdConverter.FACTORY).withCaseSensitive(false).withConformance(DRILL_CONFORMANCE).withUnquotedCasing(Casing.UNCHANGED).withQuotedCasing(Casing.UNCHANGED);
        this.sqlToRelConverterConfig = SqlToRelConverter.config().withInSubQueryThreshold((int)this.settings.getInSubqueryThreshold()).withRemoveSortInSubQuery(false).withRelBuilderConfigTransform(t -> t.withSimplify(false).withAggregateUnique(true).withPruneInputOfAggregate(false).withDedupAggregateCalls(false).withSimplifyLimit(false).withBloat(-1).withSimplifyValues(false)).withExpand(false).withRelBuilderFactory(DrillRelFactories.LOGICAL_BUILDER);
        this.isInnerQuery = false;
        this.isExpandedView = false;
        this.typeFactory = new JavaTypeFactoryImpl(DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM);
        this.defaultSchema = context.getNewDefaultSchema();
        this.rootSchema = SchemaUtilities.rootSchema(this.defaultSchema);
        this.temporarySchema = context.getConfig().getString("drill.exec.default_temporary_workspace");
        this.session = context.getSession();
        this.drillConfig = context.getConfig();
        this.catalog = new DrillCalciteCatalogReader(this.rootSchema, this.parserConfig.caseSensitive(), DynamicSchema.from((SchemaPlus)this.defaultSchema).path(null), this.typeFactory, this.drillConfig, this.session, this::useRootSchema);
        this.opTab = new ChainedSqlOperatorTable(Arrays.asList(new SqlOperatorTable[]{context.getDrillOperatorTable(), this.catalog}));
        this.costFactory = this.settings.useDefaultCosting() ? null : new DrillCostBase.DrillCostFactory();
        this.validator = SqlValidatorUtil.newValidator((SqlOperatorTable)this.opTab, (SqlValidatorCatalogReader)this.catalog, (RelDataTypeFactory)this.typeFactory, (SqlValidator.Config)SqlValidator.Config.DEFAULT.withConformance(this.parserConfig.conformance()).withTypeCoercionEnabled(true).withIdentifierExpansion(true));
        this.isImpersonationEnabled = context.isImpersonationEnabled();
        this.cluster = null;
    }

    SqlConverter(SqlConverter parent, SchemaPlus defaultSchema, SchemaPlus rootSchema, DrillCalciteCatalogReader catalog) {
        this.parserConfig = parent.parserConfig;
        this.sqlToRelConverterConfig = parent.sqlToRelConverterConfig;
        this.defaultSchema = defaultSchema;
        this.functions = parent.functions;
        this.util = parent.util;
        this.isInnerQuery = true;
        this.isExpandedView = true;
        this.typeFactory = parent.typeFactory;
        this.costFactory = parent.costFactory;
        this.settings = parent.settings;
        this.rootSchema = rootSchema;
        this.catalog = catalog;
        this.opTab = parent.opTab;
        this.planner = parent.planner;
        this.validator = SqlValidatorUtil.newValidator((SqlOperatorTable)this.opTab, (SqlValidatorCatalogReader)catalog, (RelDataTypeFactory)this.typeFactory, (SqlValidator.Config)SqlValidator.Config.DEFAULT.withConformance(this.parserConfig.conformance()).withTypeCoercionEnabled(true).withIdentifierExpansion(true));
        this.temporarySchema = parent.temporarySchema;
        this.session = parent.session;
        this.drillConfig = parent.drillConfig;
        this.cluster = parent.cluster;
        this.isImpersonationEnabled = this.util.isImpersonationEnabled();
    }

    public SqlNode parse(String sql) {
        try {
            SqlParser parser = SqlParser.create((String)sql, (SqlParser.Config)this.parserConfig);
            return parser.parseStmt();
        }
        catch (SqlParseException parseError) {
            DrillSqlParseException dex = new DrillSqlParseException(sql, parseError);
            UserException.Builder builder = UserException.parseError((Throwable)((Object)dex)).addContext(dex.getSqlWithErrorPointer());
            if (this.isInnerQuery) {
                builder.message("Failure parsing a view your query is dependent upon.", new Object[0]);
            }
            throw builder.build(logger);
        }
    }

    public SqlNode validate(SqlNode parsedNode) {
        try {
            if (this.isImpersonationEnabled) {
                return (SqlNode)ImpersonationUtil.getProcessUserUGI().doAs(() -> this.validator.validate(parsedNode));
            }
            return this.validator.validate(parsedNode);
        }
        catch (RuntimeException e) {
            UserException.Builder builder = UserException.validationError(e);
            if (this.isInnerQuery) {
                builder.message("Failure validating a view your query is dependent upon.", new Object[0]);
            }
            throw builder.build(logger);
        }
    }

    public RelRoot toRel(SqlNode validatedNode) {
        this.initCluster(this.initPlanner());
        DrillViewExpander viewExpander = new DrillViewExpander(this);
        this.util.getViewExpansionContext().setViewExpander(viewExpander);
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter((RelOptTable.ViewExpander)viewExpander, this.validator, (Prepare.CatalogReader)this.catalog, this.cluster, DrillConvertletTable.INSTANCE, this.sqlToRelConverterConfig);
        boolean topLevelQuery = !this.isInnerQuery || this.isExpandedView;
        RelRoot rel = sqlToRelConverter.convertQuery(validatedNode, false, topLevelQuery);
        if (topLevelQuery && rel.rel.getRowType().getFieldCount() - rel.fields.size() > 0) {
            RexBuilder builder = rel.rel.getCluster().getRexBuilder();
            RelNode relNode = rel.rel;
            List expressions = rel.fields.stream().map(f -> builder.makeInputRef(relNode, ((Integer)f.left).intValue())).collect(Collectors.toList());
            LogicalProject project = LogicalProject.create((RelNode)rel.rel, Collections.emptyList(), expressions, (RelDataType)rel.validatedRowType);
            rel = RelRoot.of((RelNode)project, (RelDataType)rel.validatedRowType, (SqlKind)rel.kind);
        }
        return rel.withRel(sqlToRelConverter.flattenTypes(rel.rel, true));
    }

    public RelDataType getOutputType(SqlNode validatedNode) {
        return this.validator.getValidatedNodeType(validatedNode);
    }

    public SqlValidator getValidator() {
        return this.validator;
    }

    public JavaTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public DrillConfig getDrillConfig() {
        return this.drillConfig;
    }

    public UserSession getSession() {
        return this.session;
    }

    public RelOptCostFactory getCostFactory() {
        return this.costFactory;
    }

    public SchemaPlus getRootSchema() {
        return this.rootSchema;
    }

    public SchemaPlus getDefaultSchema() {
        return this.defaultSchema;
    }

    public boolean isCaseSensitive() {
        return this.parserConfig.caseSensitive();
    }

    public void disallowTemporaryTables() {
        this.catalog.disallowTemporaryTables();
    }

    String getTemporarySchema() {
        return this.temporarySchema;
    }

    boolean useRootSchema() {
        return this.useRootSchema;
    }

    public void useRootSchemaAsDefault(boolean useRoot) {
        this.useRootSchema = useRoot;
    }

    private void initCluster(RelOptPlanner planner) {
        if (this.cluster == null) {
            this.cluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)new DrillRexBuilder((RelDataTypeFactory)this.typeFactory));
            JaninoRelMetadataProvider relMetadataProvider = Utilities.registerJaninoRelMetadataProvider();
            this.cluster.setMetadataProvider((RelMetadataProvider)relMetadataProvider);
        }
    }

    private RelOptPlanner initPlanner() {
        if (this.planner == null) {
            this.planner = new VolcanoPlanner(this.costFactory, (Context)this.settings);
            this.planner.setExecutor((RexExecutor)new DrillConstExecutor(this.functions, this.util, this.settings));
            this.planner.clearRelTraitDefs();
            this.planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
            this.planner.addRelTraitDef((RelTraitDef)DrillDistributionTraitDef.INSTANCE);
            this.planner.addRelTraitDef((RelTraitDef)RelCollationTraitDef.INSTANCE);
        }
        return this.planner;
    }
}

