/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.conversion;

import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.util.DecimalUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillRexBuilder
extends RexBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DrillRexBuilder.class);

    DrillRexBuilder(RelDataTypeFactory typeFactory) {
        super(typeFactory);
    }

    public RexNode ensureType(RelDataType type, RexNode node, boolean matchNullability) {
        return node;
    }

    public RexNode makeCast(RelDataType type, RexNode exp, boolean matchNullability) {
        if (matchNullability) {
            return this.makeAbstractCast(type, exp);
        }
        if (type.getSqlTypeName() == SqlTypeName.DECIMAL && exp instanceof RexLiteral) {
            int precision = type.getPrecision();
            int scale = type.getScale();
            this.validatePrecisionAndScale(precision, scale);
            Comparable value = (Comparable)((RexLiteral)exp).getValueAs(Comparable.class);
            if (value instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)value;
                DecimalUtility.checkValueOverflow(bigDecimal, precision, scale);
                if (bigDecimal.precision() != precision || bigDecimal.scale() != scale) {
                    return this.makeAbstractCast(type, exp);
                }
            }
        }
        return super.makeCast(type, exp, false);
    }

    private void validatePrecisionAndScale(int precision, int scale) {
        if (precision < 1) {
            throw UserException.validationError().message("Expected precision greater than 0, but was %s.", precision).build(logger);
        }
        if (scale > precision) {
            throw UserException.validationError().message("Expected scale less than or equal to precision, but was precision %s and scale %s.", precision, scale).build(logger);
        }
    }
}

