/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtilities {
    private static final Logger logger = LoggerFactory.getLogger(SchemaUtilities.class);
    public static final Joiner SCHEMA_PATH_JOINER = Joiner.on(".").skipNulls();

    public static SchemaPlus findSchema(SchemaPlus defaultSchema, List<String> schemaPath) {
        SchemaPlus rootSchema;
        if (schemaPath.size() == 0) {
            return defaultSchema;
        }
        SchemaPlus schema = SchemaUtilities.searchSchemaTree(defaultSchema, schemaPath);
        if (schema == null && (rootSchema = SchemaUtilities.rootSchema(defaultSchema)) != defaultSchema) {
            schema = SchemaUtilities.searchSchemaTree(rootSchema, schemaPath);
        }
        return schema;
    }

    public static SchemaPlus findSchema(SchemaPlus defaultSchema, String schemaPath) {
        List<String> schemaPathAsList = SchemaUtilities.getSchemaPathAsList(schemaPath);
        return SchemaUtilities.findSchema(defaultSchema, schemaPathAsList);
    }

    public static String getPrefixSchemaPath(String defaultSchema, String schemaPath, boolean isCaseSensitive) {
        if (!isCaseSensitive) {
            return Strings.commonPrefix(defaultSchema.toLowerCase(), schemaPath.toLowerCase());
        }
        return Strings.commonPrefix(defaultSchema, schemaPath);
    }

    public static SchemaPlus searchSchemaTree(SchemaPlus schema, List<String> schemaPath) {
        for (String schemaName : schemaPath) {
            if ((schema = schema.getSubSchema(schemaName.toLowerCase())) != null) continue;
            return null;
        }
        return schema;
    }

    public static boolean isRootSchema(SchemaPlus schema) {
        return schema == null || schema.getParentSchema() == null;
    }

    public static AbstractSchema unwrapAsDrillSchemaInstance(SchemaPlus schemaPlus) {
        try {
            return (AbstractSchema)((AbstractSchema)schemaPlus.unwrap(AbstractSchema.class)).getDefaultSchema();
        }
        catch (ClassCastException e) {
            throw UserException.validationError(e).message("Schema [%s] is not a Drill schema.", SchemaUtilities.getSchemaPath(schemaPlus)).build(logger);
        }
    }

    public static String getSchemaPath(SchemaPlus schema) {
        return SCHEMA_PATH_JOINER.join(SchemaUtilities.getSchemaPathAsList(schema));
    }

    public static String getSchemaPath(List<String> schemaPath) {
        return SCHEMA_PATH_JOINER.join(schemaPath);
    }

    public static List<String> getSchemaPathAsList(String schemaPath) {
        return Arrays.asList(schemaPath.split("\\."));
    }

    public static List<String> getSchemaPathAsList(SchemaPlus schema) {
        if (SchemaUtilities.isRootSchema(schema)) {
            return Collections.emptyList();
        }
        ArrayList<String> path = Lists.newArrayListWithCapacity(5);
        while (schema != null) {
            String name = schema.getName();
            if (!Strings.isNullOrEmpty(name)) {
                path.add(schema.getName());
            }
            schema = schema.getParentSchema();
        }
        return Lists.reverse(path);
    }

    public static void throwSchemaNotFoundException(SchemaPlus defaultSchema, String givenSchemaPath) {
        throw UserException.validationError().message("Schema [%s] is not valid with respect to either root schema or current default schema.", givenSchemaPath).addContext("Current default schema: ", SchemaUtilities.isRootSchema(defaultSchema) ? "No default schema selected" : SchemaUtilities.getSchemaPath(defaultSchema)).build(logger);
    }

    public static void throwSchemaNotFoundException(SchemaPlus defaultSchema, List<String> givenSchemaPath) {
        throw UserException.validationError().message("Schema [%s] is not valid with respect to either root schema or current default schema.", givenSchemaPath).addContext("Current default schema: ", SchemaUtilities.isRootSchema(defaultSchema) ? "No default schema selected" : SchemaUtilities.getSchemaPath(defaultSchema)).build(logger);
    }

    public static AbstractSchema resolveToMutableDrillSchema(SchemaPlus defaultSchema, List<String> schemaPath) {
        return SchemaUtilities.resolveToDrillSchemaInternal(defaultSchema, schemaPath, true);
    }

    public static AbstractSchema resolveToDrillSchema(SchemaPlus defaultSchema, List<String> schemaPath) {
        return SchemaUtilities.resolveToDrillSchemaInternal(defaultSchema, schemaPath, false);
    }

    private static AbstractSchema resolveToDrillSchemaInternal(SchemaPlus defaultSchema, List<String> schemaPath, boolean checkMutable) {
        SchemaPlus schema = SchemaUtilities.findSchema(defaultSchema, schemaPath);
        if (schema == null) {
            SchemaUtilities.throwSchemaNotFoundException(defaultSchema, SCHEMA_PATH_JOINER.join(schemaPath));
        }
        if (checkMutable && SchemaUtilities.isRootSchema(schema)) {
            throw UserException.validationError().message("Root schema is immutable. Drill does not allow creating or deleting tables or views in the root schema. Select a schema using 'USE schema' command.", new Object[0]).build(logger);
        }
        AbstractSchema drillSchema = SchemaUtilities.unwrapAsDrillSchemaInstance(schema);
        if (checkMutable && !drillSchema.isMutable()) {
            throw UserException.validationError().message("Unable to create or drop objects. Schema [%s] is immutable.", SchemaUtilities.getSchemaPath(schema)).build(logger);
        }
        return drillSchema;
    }

    public static AbstractSchema getTemporaryWorkspace(SchemaPlus defaultSchema, DrillConfig config) {
        String temporarySchema = config.getString("drill.exec.default_temporary_workspace");
        ArrayList<String> temporarySchemaPath = Lists.newArrayList(temporarySchema);
        SchemaPlus schema = SchemaUtilities.findSchema(defaultSchema, temporarySchemaPath);
        return schema == null ? null : SchemaUtilities.unwrapAsDrillSchemaInstance(schema);
    }

    public static boolean isTemporaryWorkspace(String schemaPath, DrillConfig config) {
        return schemaPath.equals(config.getString("drill.exec.default_temporary_workspace"));
    }

    public static WorkspaceSchemaFactory.WorkspaceSchema resolveToValidTemporaryWorkspace(AbstractSchema schema, DrillConfig config) {
        if (schema == null) {
            throw UserException.validationError().message("Default temporary workspace is not found", new Object[0]).build(logger);
        }
        if (!SchemaUtilities.isTemporaryWorkspace(schema.getFullSchemaName(), config)) {
            throw UserException.validationError().message(String.format("Temporary tables are not allowed to be created / dropped outside of default temporary workspace [%s].", config.getString("drill.exec.default_temporary_workspace")), new Object[0]).build(logger);
        }
        if (!schema.isMutable()) {
            throw UserException.validationError().message("Unable to create or drop temporary table. Schema [%s] is immutable.", schema.getFullSchemaName()).build(logger);
        }
        if (schema instanceof WorkspaceSchemaFactory.WorkspaceSchema) {
            return (WorkspaceSchemaFactory.WorkspaceSchema)schema;
        }
        throw UserException.validationError().message("Temporary workspace [%s] must be file-based, instance of WorkspaceSchemaFactory.WorkspaceSchema", schema).build(logger);
    }

    public static AbstractSchema resolveToTemporarySchema(List<String> tableSchema, SchemaPlus defaultSchema, DrillConfig config) {
        if (tableSchema.size() == 0) {
            return SchemaUtilities.getTemporaryWorkspace(defaultSchema, config);
        }
        return SchemaUtilities.resolveToMutableDrillSchema(defaultSchema, tableSchema);
    }

    public static SchemaPlus rootSchema(SchemaPlus schema) {
        while (!SchemaUtilities.isRootSchema(schema)) {
            schema = schema.getParentSchema();
        }
        return schema;
    }

    public static List<String> getSchemaPath(SqlIdentifier tableIdentifier) {
        return tableIdentifier.isSimple() ? Collections.emptyList() : tableIdentifier.names.subList(0, tableIdentifier.names.size() - 1);
    }
}

