/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import java.util.ArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.planner.sql.Checker;
import org.apache.drill.exec.planner.sql.DrillSqlOperator;
import org.apache.drill.exec.planner.sql.DynamicReturnType;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class DrillSqlOperatorWithoutInference
extends DrillSqlOperator {
    private static final TypeProtos.MajorType NONE = TypeProtos.MajorType.getDefaultInstance();
    private final TypeProtos.MajorType returnType;

    public DrillSqlOperatorWithoutInference(String name, int argCount, TypeProtos.MajorType returnType, boolean isDeterminisitic, boolean isNiladic, boolean isVarArg) {
        super(name, new ArrayList<DrillFuncHolder>(), (SqlOperandTypeChecker)(isVarArg ? OperandTypes.VARIADIC : Checker.getChecker(argCount, argCount)), isDeterminisitic, (SqlReturnTypeInference)DynamicReturnType.INSTANCE, isNiladic);
        this.returnType = Preconditions.checkNotNull(returnType);
    }

    protected RelDataType getReturnDataType(RelDataTypeFactory factory) {
        if (TypeProtos.MinorType.BIT.equals(this.returnType.getMinorType())) {
            return factory.createSqlType(SqlTypeName.BOOLEAN);
        }
        return factory.createTypeWithNullability(factory.createSqlType(SqlTypeName.ANY), true);
    }

    private RelDataType getNullableReturnDataType(RelDataTypeFactory factory) {
        return factory.createTypeWithNullability(this.getReturnDataType(factory), true);
    }

    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        if (NONE.equals(this.returnType)) {
            return validator.getTypeFactory().createSqlType(SqlTypeName.ANY);
        }
        return this.getNullableReturnDataType(validator.getTypeFactory());
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        return this.getNullableReturnDataType(opBinding.getTypeFactory());
    }
}

