/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import java.util.ArrayList;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlBetweenOperator;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.planner.sql.DrillCalciteSqlWrapper;
import org.apache.drill.exec.planner.sql.TypeInferenceUtils;
import org.apache.drill.exec.resolver.TypeCastRules;

public class DrillCalciteSqlBetweenOperatorWrapper
extends SqlBetweenOperator
implements DrillCalciteSqlWrapper {
    private final SqlBetweenOperator operator;

    public DrillCalciteSqlBetweenOperatorWrapper(SqlBetweenOperator sqlBetweenOperator) {
        super(sqlBetweenOperator.flag, sqlBetweenOperator.isNegated());
        this.operator = sqlBetweenOperator;
    }

    @Override
    public SqlOperator getOperator() {
        return this.operator;
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        boolean isCompatible;
        ArrayList<TypeProtos.MinorType> types = new ArrayList<TypeProtos.MinorType>();
        for (int i = 0; i < callBinding.getOperandCount(); ++i) {
            TypeProtos.MinorType inMinorType = TypeInferenceUtils.getDrillTypeFromCalciteType(callBinding.getOperandType(i));
            if (inMinorType == TypeProtos.MinorType.LATE) {
                return true;
            }
            types.add(inMinorType);
        }
        boolean bl = isCompatible = TypeCastRules.getLeastRestrictiveType(types.toArray(new TypeProtos.MinorType[0])) != null;
        if (!isCompatible && throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return isCompatible;
    }
}

