/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.ScreenPrel;
import org.apache.drill.exec.planner.physical.WriterPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;

public class TopProjectVisitor
extends BasePrelVisitor<Prel, Void, RuntimeException> {
    private final RelDataType validatedRowType;

    public TopProjectVisitor(RelDataType validatedRowType) {
        this.validatedRowType = validatedRowType;
    }

    public static Prel insertTopProject(Prel prel, RelDataType validatedRowType) {
        return prel.accept(new TopProjectVisitor(validatedRowType), null);
    }

    @Override
    public Prel visitPrel(Prel prel, Void value) throws RuntimeException {
        ArrayList<Prel> children = new ArrayList<Prel>();
        for (Prel child : prel) {
            child = child.accept(this, null);
            children.add(child);
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    @Override
    public Prel visitScreen(ScreenPrel prel, Void value) {
        if (this.containsWriter(prel) || prel.getRowType().getFieldList().stream().allMatch(RelDataTypeField::isDynamicStar)) {
            return prel;
        }
        Prel newChild = ((Prel)prel.getInput()).accept(this, value);
        return prel.copy(prel.getTraitSet(), Collections.singletonList(this.addTopProjectPrel(newChild, this.validatedRowType)));
    }

    @Override
    public Prel visitWriter(WriterPrel prel, Void value) {
        Prel newChild = ((Prel)prel.getInput()).accept(this, value);
        return prel.copy(prel.getTraitSet(), Collections.singletonList(this.addTopProjectPrel(newChild, this.validatedRowType)));
    }

    private boolean containsWriter(Prel prel) {
        for (Prel child : prel) {
            if (!(child instanceof WriterPrel) && !this.containsWriter(child)) continue;
            return true;
        }
        return false;
    }

    private Prel addTopProjectPrel(Prel prel, RelDataType validatedRowType) {
        RelDataType rowType = prel.getRowType();
        if (rowType.getFieldCount() != validatedRowType.getFieldCount()) {
            return prel;
        }
        RexBuilder rexBuilder = prel.getCluster().getRexBuilder();
        ArrayList<RexNode> projections = new ArrayList<RexNode>();
        int projectCount = rowType.getFieldList().size();
        for (int i = 0; i < projectCount; ++i) {
            projections.add((RexNode)rexBuilder.makeInputRef((RelNode)prel, i));
        }
        List fieldNames = SqlValidatorUtil.uniquify((List)validatedRowType.getFieldNames(), (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)prel.getCluster().getTypeFactory().getTypeSystem().isSchemaCaseSensitive());
        RelDataType newRowType = RexUtil.createStructType((RelDataTypeFactory)prel.getCluster().getTypeFactory(), projections, (List)fieldNames, null);
        ProjectPrel topProject = new ProjectPrel(prel.getCluster(), prel.getTraitSet(), prel, projections, newRowType, true);
        if (prel instanceof Project && DrillRelOptUtil.isTrivialProject(topProject, true)) {
            return new ProjectPrel(prel.getCluster(), prel.getTraitSet(), ((Project)prel).getInput(), ((Project)prel).getProjects(), prel.getRowType(), true);
        }
        return topProject;
    }
}

