/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.exec.planner.physical.HashJoinPrel;
import org.apache.drill.exec.planner.physical.JoinPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class SwapHashJoinVisitor
extends BasePrelVisitor<Prel, Double, RuntimeException> {
    private static SwapHashJoinVisitor INSTANCE = new SwapHashJoinVisitor();

    public static Prel swapHashJoin(Prel prel, Double marginFactor) {
        return prel.accept(INSTANCE, marginFactor);
    }

    private SwapHashJoinVisitor() {
    }

    @Override
    public Prel visitPrel(Prel prel, Double value) throws RuntimeException {
        ArrayList<Prel> children = Lists.newArrayList();
        for (Prel child : prel) {
            child = child.accept(this, value);
            children.add(child);
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    @Override
    public Prel visitJoin(JoinPrel prel, Double value) throws RuntimeException {
        JoinPrel newJoin = (JoinPrel)this.visitPrel((Prel)prel, value);
        if (prel instanceof HashJoinPrel && !((HashJoinPrel)prel).isRowKeyJoin()) {
            RelMetadataQuery mq = newJoin.getCluster().getMetadataQuery();
            if (newJoin.getLeft().estimateRowCount(mq) < (1.0 + value) * newJoin.getRight().estimateRowCount(mq) && newJoin.getJoinType() == JoinRelType.INNER && !newJoin.isSemiJoin()) {
                ((HashJoinPrel)newJoin).setSwapped(true);
            }
        }
        return newJoin;
    }
}

