/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.Pair;
import org.apache.drill.exec.planner.StarColumnHelper;
import org.apache.drill.exec.planner.physical.LeafPrel;
import org.apache.drill.exec.planner.physical.MetadataControllerPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectAllowDupPrel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.planner.physical.ScreenPrel;
import org.apache.drill.exec.planner.physical.UnnestPrel;
import org.apache.drill.exec.planner.physical.WriterPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class StarColumnConverter
extends BasePrelVisitor<Prel, Void, RuntimeException> {
    private static final AtomicLong tableNumber = new AtomicLong(0L);
    private boolean prefixedForStar = false;
    private boolean prefixedForWriter = false;

    private StarColumnConverter() {
    }

    public static Prel insertRenameProject(Prel root) {
        return root.accept(new StarColumnConverter(), null);
    }

    @Override
    public Prel visitScreen(ScreenPrel prel, Void value) throws RuntimeException {
        Prel child = ((Prel)prel.getInput(0)).accept(this, null);
        if (this.prefixedForStar) {
            if (this.prefixedForWriter) {
                return prel.copy(prel.getTraitSet(), Collections.singletonList(child));
            }
            return this.insertProjUnderScreenOrWriter(prel, prel.getInput().getRowType(), child);
        }
        return prel;
    }

    @Override
    public Prel visitWriter(WriterPrel prel, Void value) throws RuntimeException {
        RelNode child = ((Prel)prel.getInput(0)).accept(this, null);
        if (this.prefixedForStar) {
            this.prefixedForWriter = true;
            return prel.copy(prel.getTraitSet(), (List)Collections.singletonList(child));
        }
        return prel;
    }

    private Prel insertProjUnderScreenOrWriter(Prel prel, RelDataType origRowType, Prel child) {
        ArrayList<ProjectAllowDupPrel> children = Lists.newArrayList();
        ArrayList<RexNode> exprs = Lists.newArrayList();
        for (int i = 0; i < origRowType.getFieldCount(); ++i) {
            RexInputRef expr = child.getCluster().getRexBuilder().makeInputRef(((RelDataTypeField)origRowType.getFieldList().get(i)).getType(), i);
            exprs.add((RexNode)expr);
        }
        RelDataType newRowType = RexUtil.createStructType((RelDataTypeFactory)child.getCluster().getTypeFactory(), exprs, (List)origRowType.getFieldNames(), null);
        int fieldCount = prel.getRowType().isStruct() ? prel.getRowType().getFieldCount() : 1;
        ProjectPrel proj = fieldCount > 1 ? new ProjectAllowDupPrel(child.getCluster(), child.getTraitSet(), child, exprs, newRowType, true) : new ProjectPrel(child.getCluster(), child.getTraitSet(), child, exprs, newRowType, true);
        children.add((ProjectAllowDupPrel)proj);
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    @Override
    public Prel visitProject(ProjectPrel prel, Void value) throws RuntimeException {
        if (!this.prefixedForStar && StarColumnHelper.containsStarColumnInProject(prel.getInput().getRowType(), prel.getProjects()) && prel.getRowType().getFieldNames().size() > 1) {
            this.prefixedForStar = true;
        }
        Prel child = ((Prel)prel.getInput(0)).accept(this, null);
        List<String> fieldNames = Lists.newArrayList();
        for (Pair pair : Pair.zip((List)prel.getRowType().getFieldNames(), (List)prel.getProjects())) {
            if (pair.right instanceof RexInputRef) {
                String name = (String)child.getRowType().getFieldNames().get(((RexInputRef)pair.right).getIndex());
                fieldNames.add(name);
                continue;
            }
            fieldNames.add((String)pair.left);
        }
        fieldNames = this.makeUniqueNames(fieldNames);
        RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)prel.getCluster().getTypeFactory(), (List)prel.getProjects(), fieldNames, null);
        ProjectPrel newProj = (ProjectPrel)prel.copy(prel.getTraitSet(), child, prel.getProjects(), rowType);
        if (ProjectRemoveRule.isTrivial((Project)newProj)) {
            return child;
        }
        return newProj;
    }

    @Override
    public Prel visitPrel(Prel prel, Void value) throws RuntimeException {
        if (prel instanceof MetadataControllerPrel) {
            return prel;
        }
        if (!this.prefixedForStar && StarColumnHelper.containsStarColumn(prel.getRowType()) && prel.getRowType().getFieldNames().size() > 1 && !(prel instanceof LeafPrel)) {
            this.prefixedForStar = true;
        }
        ArrayList<Prel> children = Lists.newArrayList();
        for (Prel child : prel) {
            child = child.accept(this, null);
            children.add(child);
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    private Prel prefixTabNameToStar(Prel prel, Void value) throws RuntimeException {
        if (StarColumnHelper.containsStarColumn(prel.getRowType()) && this.prefixedForStar) {
            ArrayList<RexNode> exprs = Lists.newArrayList();
            for (RelDataTypeField field : prel.getRowType().getFieldList()) {
                RexInputRef expr = prel.getCluster().getRexBuilder().makeInputRef(field.getType(), field.getIndex());
                exprs.add((RexNode)expr);
            }
            ArrayList<String> fieldNames = Lists.newArrayList();
            long tableId = tableNumber.getAndIncrement();
            for (String name : prel.getRowType().getFieldNames()) {
                if (StarColumnHelper.isNonPrefixedStarColumn(name)) {
                    fieldNames.add("T" + tableId + "\u00a6\u00a6" + name);
                    continue;
                }
                fieldNames.add(name);
            }
            RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)prel.getCluster().getTypeFactory(), exprs, fieldNames, null);
            ProjectPrel proj = new ProjectPrel(prel.getCluster(), prel.getTraitSet(), prel, exprs, rowType);
            return proj;
        }
        return this.visitPrel(prel, value);
    }

    @Override
    public Prel visitScan(ScanPrel scanPrel, Void value) throws RuntimeException {
        return this.visitLeaf((LeafPrel)scanPrel, value);
    }

    @Override
    public Prel visitLeaf(LeafPrel prel, Void value) throws RuntimeException {
        return this.prefixTabNameToStar(prel, value);
    }

    @Override
    public Prel visitUnnest(UnnestPrel unnestPrel, Void value) throws RuntimeException {
        return this.visitLeaf((LeafPrel)unnestPrel, value);
    }

    private List<String> makeUniqueNames(List<String> names) {
        HashSet<String> uniqueNames = new HashSet<String>();
        HashSet<String> origNames = new HashSet<String>(names);
        ArrayList<String> newNames = Lists.newArrayList();
        for (String s : names) {
            if (uniqueNames.contains(s)) {
                int i = 0;
                while (origNames.contains(s = s + i) || uniqueNames.contains(s)) {
                    ++i;
                }
            }
            uniqueNames.add(s);
            newNames.add(s);
        }
        return newNames;
    }
}

