/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.RelConversionException;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.exec.planner.physical.visitor.RexVisitorComplexExprSplitter;
import org.apache.drill.exec.planner.types.RelDataTypeDrillImpl;
import org.apache.drill.exec.planner.types.RelDataTypeHolder;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class SplitUpComplexExpressions
extends BasePrelVisitor<Prel, Object, RelConversionException> {
    private final RelDataTypeFactory factory;
    private final RexBuilder rexBuilder;
    private final FunctionImplementationRegistry funcReg;

    public SplitUpComplexExpressions(RelDataTypeFactory factory, FunctionImplementationRegistry funcReg, RexBuilder rexBuilder) {
        this.factory = factory;
        this.funcReg = funcReg;
        this.rexBuilder = rexBuilder;
    }

    @Override
    public Prel visitPrel(Prel prel, Object unused) throws RelConversionException {
        ArrayList<Prel> children = new ArrayList<Prel>();
        for (Prel child : prel) {
            child = child.accept(this, unused);
            children.add(child);
        }
        if (children.equals(prel.getInputs())) {
            return prel;
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    @Override
    public Prel visitProject(ProjectPrel project, Object unused) throws RelConversionException {
        Prel oldInput = (Prel)project.getInput(0);
        RelNode newInput = oldInput.accept(this, unused);
        ProjectPrel newProject = (ProjectPrel)project.copy(project.getTraitSet(), Lists.newArrayList(newInput));
        int lastColumnReferenced = PrelUtil.getLastUsedColumnReference(newProject.getProjects());
        if (lastColumnReferenced == -1) {
            return newProject;
        }
        List projectFields = newProject.getRowType().getFieldList();
        ArrayList<RelDataTypeField> origRelDataTypes = new ArrayList<RelDataTypeField>();
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        int lastRexInput = lastColumnReferenced + 1;
        RexVisitorComplexExprSplitter exprSplitter = new RexVisitorComplexExprSplitter(this.funcReg, this.rexBuilder, lastRexInput);
        int i = 0;
        for (RexNode rex : newProject.getProjects()) {
            RelDataTypeField originField = (RelDataTypeField)projectFields.get(i++);
            RexNode splitRex = (RexNode)rex.accept((RexVisitor)exprSplitter);
            origRelDataTypes.add(originField);
            exprList.add(splitRex);
        }
        List<RexNode> complexExprs = exprSplitter.getComplexExprs();
        if (complexExprs.size() == 1 && this.findTopComplexFunc(newProject.getProjects()).size() == 1) {
            return newProject;
        }
        if (complexExprs.size() > 0) {
            ArrayList<Object> allExprs = new ArrayList<Object>();
            int exprIndex = 0;
            List fieldNames = newInput.getRowType().getFieldNames();
            ArrayList<RelDataTypeFieldImpl> relDataTypes = new ArrayList<RelDataTypeFieldImpl>();
            for (int index = 0; index < lastRexInput; ++index) {
                allExprs.add(this.rexBuilder.makeInputRef((RelDataType)new RelDataTypeDrillImpl(new RelDataTypeHolder(), this.factory), index));
                if (((String)fieldNames.get(index)).contains("**")) {
                    relDataTypes.add(new RelDataTypeFieldImpl((String)fieldNames.get(index), allExprs.size(), this.factory.createSqlType(SqlTypeName.ANY)));
                    continue;
                }
                relDataTypes.add(new RelDataTypeFieldImpl(this.getExprName(exprIndex), allExprs.size(), this.factory.createSqlType(SqlTypeName.ANY)));
                ++exprIndex;
            }
            int index = lastRexInput - 1;
            while (complexExprs.size() > 0) {
                if (index >= lastRexInput) {
                    RexInputRef newLastRex = this.rexBuilder.makeInputRef((RelDataType)new RelDataTypeDrillImpl(new RelDataTypeHolder(), this.factory), index);
                    allExprs.set(allExprs.size() - 1, newLastRex);
                }
                ++index;
                RexNode currRexNode = complexExprs.remove(0);
                allExprs.add(currRexNode);
                relDataTypes.add(new RelDataTypeFieldImpl(this.getExprName(++exprIndex), allExprs.size(), this.factory.createSqlType(SqlTypeName.ANY)));
                RelRecordType childProjectType = new RelRecordType(relDataTypes);
                newInput = new ProjectPrel(newProject.getCluster(), newProject.getTraitSet(), newInput, ImmutableList.copyOf(allExprs), (RelDataType)childProjectType);
            }
            allExprs.set(allExprs.size() - 1, this.rexBuilder.makeInputRef((RelDataType)new RelDataTypeDrillImpl(new RelDataTypeHolder(), this.factory), index));
            relDataTypes.add(new RelDataTypeFieldImpl(this.getExprName(exprIndex), allExprs.size(), this.factory.createSqlType(SqlTypeName.ANY)));
        }
        return (Prel)project.copy(project.getTraitSet(), newInput, exprList, (RelDataType)new RelRecordType(origRelDataTypes));
    }

    private String getExprName(int exprIndex) {
        return SqlValidatorUtil.EXPR_SUGGESTER.apply(null, exprIndex, 0);
    }

    private List<RexNode> findTopComplexFunc(List<RexNode> exprs) {
        ArrayList<RexNode> topComplexFuncs = new ArrayList<RexNode>();
        for (RexNode exp : exprs) {
            RexCall call;
            String functionName;
            if (!(exp instanceof RexCall) || !this.funcReg.isFunctionComplexOutput(functionName = (call = (RexCall)exp).getOperator().getName())) continue;
            topComplexFuncs.add(exp);
        }
        return topComplexFuncs;
    }
}

