/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.SelectionVectorRemoverPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class SelectionVectorPrelVisitor
extends BasePrelVisitor<Prel, Void, RuntimeException> {
    private static final SelectionVectorPrelVisitor INSTANCE = new SelectionVectorPrelVisitor();

    public static Prel addSelectionRemoversWhereNecessary(Prel prel) {
        return prel.accept(INSTANCE, null);
    }

    @Override
    public Prel visitPrel(Prel prel, Void value) throws RuntimeException {
        BatchSchema.SelectionVectorMode[] encodings = prel.getSupportedEncodings();
        ArrayList<Prel> children = Lists.newArrayList();
        for (Prel child : prel) {
            child = child.accept(this, null);
            children.add(this.convert(encodings, child));
        }
        if (children.equals(prel.getInputs())) {
            return prel;
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    private Prel convert(BatchSchema.SelectionVectorMode[] encodings, Prel prel) {
        for (BatchSchema.SelectionVectorMode m : encodings) {
            if (prel.getEncoding() != m) continue;
            return prel;
        }
        return new SelectionVectorRemoverPrel(prel);
    }
}

