/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;

public class RexVisitorComplexExprSplitter
extends RexVisitorImpl<RexNode> {
    private final FunctionImplementationRegistry funcReg;
    private final RexBuilder rexBuilder;
    private final List<RexNode> complexExprs;
    private int lastUsedIndex;

    public RexVisitorComplexExprSplitter(FunctionImplementationRegistry funcReg, RexBuilder rexBuilder, int firstUnused) {
        super(true);
        this.funcReg = funcReg;
        this.rexBuilder = rexBuilder;
        this.complexExprs = new ArrayList<RexNode>();
        this.lastUsedIndex = firstUnused;
    }

    public List<RexNode> getComplexExprs() {
        return this.complexExprs;
    }

    public RexNode visitInputRef(RexInputRef inputRef) {
        return inputRef;
    }

    public RexNode visitLocalRef(RexLocalRef localRef) {
        return localRef;
    }

    public RexNode visitLiteral(RexLiteral literal) {
        return literal;
    }

    public RexNode visitOver(RexOver over) {
        return over;
    }

    public RexNode visitCorrelVariable(RexCorrelVariable correlVariable) {
        return correlVariable;
    }

    public RexNode visitCall(RexCall call) {
        ArrayList<RexNode> newOps = new ArrayList<RexNode>();
        for (RexNode operand : call.operands) {
            RexNode newOp = (RexNode)operand.accept((RexVisitor)this);
            newOps.add(newOp);
        }
        RexCall newCall = call.clone(call.getType(), newOps);
        String functionName = call.getOperator().getName();
        if (this.funcReg.isFunctionComplexOutput(functionName)) {
            RexInputRef ret = this.rexBuilder.makeInputRef(newCall.getType(), this.lastUsedIndex++);
            this.complexExprs.add((RexNode)newCall);
            return ret;
        }
        return newCall;
    }

    public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
        return dynamicParam;
    }

    public RexNode visitRangeRef(RexRangeRef rangeRef) {
        return rangeRef;
    }

    public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
        return fieldAccess;
    }
}

