/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.rules.ProjectCorrelateTransposeRule;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.exec.planner.physical.LateralJoinPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.UnnestPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class LateralUnnestRowIDVisitor
extends BasePrelVisitor<Prel, Boolean, RuntimeException> {
    private static final LateralUnnestRowIDVisitor INSTANCE = new LateralUnnestRowIDVisitor();

    public static Prel insertRowID(Prel prel) {
        return prel.accept(INSTANCE, false);
    }

    @Override
    public Prel visitPrel(Prel prel, Boolean isRightOfLateral) throws RuntimeException {
        List<RelNode> children = this.getChildren(prel, isRightOfLateral);
        if (isRightOfLateral.booleanValue()) {
            return prel.prepareForLateralUnnestPipeline(children);
        }
        if (children.equals(prel.getInputs())) {
            return prel;
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    private List<RelNode> getChildren(Prel prel, Boolean isRightOfLateral) {
        ArrayList<RelNode> children = Lists.newArrayList();
        for (Prel child : prel) {
            child = child.accept(this, isRightOfLateral);
            children.add(child);
        }
        return children;
    }

    @Override
    public Prel visitLateral(LateralJoinPrel prel, Boolean isRightOfLateral) throws RuntimeException {
        ArrayList<RelNode> children = Lists.newArrayList();
        children.add(((Prel)prel.getInput(0)).accept(this, isRightOfLateral));
        children.add(((Prel)prel.getInput(1)).accept(this, true));
        if (!isRightOfLateral.booleanValue()) {
            return (Prel)prel.copy(prel.getTraitSet(), children);
        }
        HashMap<Integer, Integer> requiredColsMap = new HashMap<Integer, Integer>();
        for (Integer corrColIndex : prel.getRequiredColumns()) {
            requiredColsMap.put(corrColIndex, corrColIndex + 1);
        }
        ImmutableBitSet requiredColumns = prel.getRequiredColumns().shift(1);
        CorrelationId corrId = prel.getCluster().createCorrel();
        RexCorrelVariable updatedCorrel = (RexCorrelVariable)prel.getCluster().getRexBuilder().makeCorrel(((RelNode)children.get(0)).getRowType(), corrId);
        RelNode rightChild = ((RelNode)children.get(1)).accept((RelShuttle)new CorrelateVarReplacer((RexShuttle)new ProjectCorrelateTransposeRule.RexFieldAccessReplacer(prel.getCorrelationId(), updatedCorrel, prel.getCluster().getRexBuilder(), requiredColsMap)));
        return (Prel)prel.copy(prel.getTraitSet(), (RelNode)children.get(0), rightChild, corrId, requiredColumns, prel.getJoinType());
    }

    @Override
    public Prel visitUnnest(UnnestPrel prel, Boolean isRightOfLateral) throws RuntimeException {
        return prel.prepareForLateralUnnestPipeline(null);
    }

    public static class CorrelateVarReplacer
    extends ProjectCorrelateTransposeRule.RelNodesExprsHandler {
        protected final RexShuttle rexVisitor;

        public CorrelateVarReplacer(RexShuttle rexVisitor) {
            super(rexVisitor);
            this.rexVisitor = rexVisitor;
        }

        public RelNode visit(RelNode other) {
            return super.visit(other.accept(this.rexVisitor));
        }
    }
}

