/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class InsertLocalExchangeVisitor
extends BasePrelVisitor<Prel, Void, RuntimeException> {
    private final OptionManager options;

    private static boolean isMuxEnabled(OptionManager options) {
        return options.getOption((String)PlannerSettings.MUX_EXCHANGE.getOptionName()).bool_val != false || options.getOption((String)PlannerSettings.DEMUX_EXCHANGE.getOptionName()).bool_val != false || options.getOption((String)PlannerSettings.ORDERED_MUX_EXCHANGE.getOptionName()).bool_val != false;
    }

    public static Prel insertLocalExchanges(Prel prel, OptionManager options) {
        if (InsertLocalExchangeVisitor.isMuxEnabled(options)) {
            return prel.accept(new InsertLocalExchangeVisitor(options), null);
        }
        return prel;
    }

    public InsertLocalExchangeVisitor(OptionManager options) {
        this.options = options;
    }

    @Override
    public Prel visitExchange(ExchangePrel prel, Void value) throws RuntimeException {
        Prel child = ((Prel)prel.getInput()).accept(this, null);
        return prel.constructMuxPrel(child, this.options);
    }

    @Override
    public Prel visitPrel(Prel prel, Void value) throws RuntimeException {
        ArrayList<RelNode> children = Lists.newArrayList();
        for (Prel child : prel) {
            children.add(child.accept(this, null));
        }
        if (children.equals(prel.getInputs())) {
            return prel;
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }
}

