/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.ScreenPrel;
import org.apache.drill.exec.planner.physical.SetOpPrel;
import org.apache.drill.exec.planner.physical.UnionPrel;
import org.apache.drill.exec.planner.physical.WriterPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class FinalColumnReorderer
extends BasePrelVisitor<Prel, Void, RuntimeException> {
    private static final FinalColumnReorderer INSTANCE = new FinalColumnReorderer();

    public static Prel addFinalColumnOrdering(Prel prel) {
        return prel.accept(INSTANCE, null);
    }

    @Override
    public Prel visitScreen(ScreenPrel prel, Void value) throws RuntimeException {
        Prel newChild = this.addTrivialOrderedProjectPrel(((Prel)prel.getInput()).accept(this, value), true);
        if (newChild == prel.getInput()) {
            return prel;
        }
        return prel.copy(prel.getTraitSet(), Collections.singletonList(newChild));
    }

    private Prel addTrivialOrderedProjectPrel(Prel prel) {
        RelDataType t = prel.getRowType();
        RexBuilder b = prel.getCluster().getRexBuilder();
        ArrayList<RexNode> projections = Lists.newArrayList();
        int projectCount = t.getFieldList().size();
        if (projectCount < 2) {
            return prel;
        }
        for (int i = 0; i < projectCount; ++i) {
            projections.add((RexNode)b.makeInputRef((RelNode)prel, i));
        }
        return new ProjectPrel(prel.getCluster(), prel.getTraitSet(), prel, projections, prel.getRowType());
    }

    private Prel addTrivialOrderedProjectPrel(Prel prel, boolean checkNecessity) {
        if (checkNecessity && !prel.needsFinalColumnReordering()) {
            return prel;
        }
        return this.addTrivialOrderedProjectPrel(prel);
    }

    @Override
    public Prel visitWriter(WriterPrel prel, Void value) throws RuntimeException {
        Prel newChild = ((Prel)prel.getInput()).accept(this, null);
        if (newChild == prel.getInput()) {
            return prel;
        }
        return prel.copy(prel.getTraitSet(), Collections.singletonList(this.addTrivialOrderedProjectPrel(newChild, true)));
    }

    @Override
    public Prel visitPrel(Prel prel, Void value) throws RuntimeException {
        if (prel instanceof UnionPrel || prel instanceof SetOpPrel) {
            return this.addColumnOrderingBelow(prel);
        }
        ArrayList<Prel> children = Lists.newArrayList();
        boolean changed = false;
        for (Prel p : prel) {
            Prel newP = p.accept(this, null);
            if (newP != p) {
                changed = true;
            }
            children.add(newP);
        }
        if (changed) {
            return (Prel)prel.copy(prel.getTraitSet(), children);
        }
        return prel;
    }

    private Prel addColumnOrderingBelow(Prel prel) {
        ArrayList<Prel> children = Lists.newArrayList();
        for (Prel p : prel) {
            boolean needProjectBelow;
            Prel child = p.accept(this, null);
            boolean bl = needProjectBelow = !(p instanceof ProjectPrel);
            if (needProjectBelow) {
                child = this.addTrivialOrderedProjectPrel(child, false);
            }
            children.add(child);
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }
}

