/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.planner.fragment.DistributionAffinity;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.FilterPrel;
import org.apache.drill.exec.planner.physical.HashToMergeExchangePrel;
import org.apache.drill.exec.planner.physical.LateralJoinPrel;
import org.apache.drill.exec.planner.physical.LimitPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.planner.physical.ScreenPrel;
import org.apache.drill.exec.planner.physical.SingleMergeExchangePrel;
import org.apache.drill.exec.planner.physical.UnnestPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class ExcessiveExchangeIdentifier
extends BasePrelVisitor<Prel, MajorFragmentStat, RuntimeException> {
    private final long targetSliceSize;
    private LateralJoinPrel topMostLateralJoin;

    public ExcessiveExchangeIdentifier(long targetSliceSize) {
        this.targetSliceSize = targetSliceSize;
    }

    public static Prel removeExcessiveExchanges(Prel prel, long targetSliceSize) {
        ExcessiveExchangeIdentifier exchange = new ExcessiveExchangeIdentifier(targetSliceSize);
        return prel.accept(exchange, exchange.getNewStat());
    }

    @Override
    public Prel visitExchange(ExchangePrel prel, MajorFragmentStat parent) throws RuntimeException {
        parent.add(prel);
        MajorFragmentStat newFrag = new MajorFragmentStat();
        newFrag.setRightSideOfLateral(parent.isRightSideOfLateral());
        if (prel instanceof SingleMergeExchangePrel) {
            newFrag.isSimpleRel = true;
        }
        Prel newChild = ((Prel)prel.getInput()).accept(this, newFrag);
        if (parent.isSimpleRel && prel instanceof HashToMergeExchangePrel) {
            return newChild;
        }
        if (this.canRemoveExchange(parent, newFrag)) {
            return newChild;
        }
        if (newChild != prel.getInput()) {
            return (Prel)prel.copy(prel.getTraitSet(), Collections.singletonList(newChild));
        }
        return prel;
    }

    private boolean canRemoveExchange(MajorFragmentStat parentFrag, MajorFragmentStat childFrag) {
        if (childFrag.isSingular() && parentFrag.isSingular() && (!childFrag.isDistributionStrict() || !parentFrag.isDistributionStrict())) {
            return true;
        }
        return parentFrag.isRightSideOfLateral();
    }

    @Override
    public Prel visitScreen(ScreenPrel prel, MajorFragmentStat s) throws RuntimeException {
        s.addScreen(prel);
        RelNode child = ((Prel)prel.getInput()).accept(this, s);
        if (child == prel.getInput()) {
            return prel;
        }
        return prel.copy(prel.getTraitSet(), (List)Collections.singletonList(child));
    }

    @Override
    public Prel visitScan(ScanPrel prel, MajorFragmentStat s) throws RuntimeException {
        s.addScan(prel);
        return prel;
    }

    @Override
    public Prel visitLateral(LateralJoinPrel prel, MajorFragmentStat s) throws RuntimeException {
        ArrayList<RelNode> children = Lists.newArrayList();
        s.add(prel);
        for (Prel p : prel) {
            s.add(p);
        }
        children.add(((Prel)prel.getInput(0)).accept(this, s));
        if (this.topMostLateralJoin == null) {
            this.topMostLateralJoin = prel;
        }
        s.setRightSideOfLateral(true);
        children.add(((Prel)prel.getInput(1)).accept(this, s));
        if (this.topMostLateralJoin == prel) {
            this.topMostLateralJoin = null;
            s.setRightSideOfLateral(false);
        }
        if (children.equals(prel.getInputs())) {
            return prel;
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    @Override
    public Prel visitUnnest(UnnestPrel prel, MajorFragmentStat s) throws RuntimeException {
        s.addUnnest(prel);
        return prel;
    }

    @Override
    public Prel visitPrel(Prel prel, MajorFragmentStat s) throws RuntimeException {
        ArrayList<RelNode> children = Lists.newArrayList();
        s.add(prel);
        for (Prel p : prel) {
            s.add(p);
        }
        s.setHashDistribution(prel);
        for (Prel p : prel) {
            children.add(p.accept(this, s));
        }
        if (children.equals(prel.getInputs())) {
            return prel;
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    public MajorFragmentStat getNewStat() {
        return new MajorFragmentStat();
    }

    class MajorFragmentStat {
        private DistributionAffinity distributionAffinity = DistributionAffinity.NONE;
        private double maxRows;
        private int maxWidth = Integer.MAX_VALUE;
        private boolean isMultiSubScan;
        private boolean rightSideOfLateral;
        private boolean isSimpleRel;

        MajorFragmentStat() {
        }

        public void add(Prel prel) {
            this.maxRows = Math.max(prel.estimateRowCount(prel.getCluster().getMetadataQuery()), this.maxRows);
        }

        public void addScreen(ScreenPrel screenPrel) {
            this.maxWidth = 1;
            this.distributionAffinity = screenPrel.getDistributionAffinity();
        }

        public void addScan(ScanPrel prel) {
            this.maxWidth = Math.min(this.maxWidth, prel.getGroupScan().getMaxParallelizationWidth());
            this.isMultiSubScan = prel.getGroupScan().getMinParallelizationWidth() > 1;
            this.distributionAffinity = prel.getDistributionAffinity();
            this.add(prel);
        }

        public void setHashDistribution(Prel prel) {
            this.isSimpleRel = this.isSimpleRel && (prel instanceof LimitPrel || prel instanceof ProjectPrel || prel instanceof FilterPrel);
        }

        public boolean isSingular() {
            if (this.isMultiSubScan) {
                return false;
            }
            int suggestedWidth = (int)Math.ceil((this.maxRows + 1.0) / (double)ExcessiveExchangeIdentifier.this.targetSliceSize);
            int w = Math.min(this.maxWidth, suggestedWidth);
            if (w < 1) {
                w = 1;
            }
            return w == 1;
        }

        public boolean isRightSideOfLateral() {
            return this.rightSideOfLateral;
        }

        public void addUnnest(UnnestPrel prel) {
            this.add(prel);
        }

        public void setRightSideOfLateral(boolean rightSideOfLateral) {
            this.rightSideOfLateral = rightSideOfLateral;
        }

        public boolean isDistributionStrict() {
            return this.distributionAffinity == DistributionAffinity.HARD;
        }
    }
}

