/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.explain;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.Spacer;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Pair;
import org.apache.drill.exec.planner.physical.HashJoinPrel;
import org.apache.drill.exec.planner.physical.LateralJoinPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.UnnestPrel;
import org.apache.drill.exec.planner.physical.explain.PrelSequencer;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

class NumberingRelWriter
implements RelWriter {
    protected final PrintWriter pw;
    private final SqlExplainLevel detailLevel;
    protected final Spacer spacer = new Spacer();
    private final List<Pair<String, Object>> values = new ArrayList<Pair<String, Object>>();
    private final Map<String, Prel> sourceOperatorRegistry;
    private final Map<Prel, PrelSequencer.OpId> ids;

    public NumberingRelWriter(Map<Prel, PrelSequencer.OpId> ids, PrintWriter pw, SqlExplainLevel detailLevel) {
        this.pw = pw;
        this.ids = ids;
        this.detailLevel = detailLevel;
        this.sourceOperatorRegistry = new HashMap<String, Prel>();
    }

    protected void explain_(RelNode rel, List<Pair<String, Object>> values) {
        RelMetadataQuery mq = RelMetadataQuery.instance();
        if (!mq.isVisibleInExplain(rel, this.detailLevel).booleanValue()) {
            this.explainInputs(rel);
            return;
        }
        StringBuilder s = new StringBuilder();
        PrelSequencer.OpId id = this.ids.get(rel);
        if (id != null) {
            s.append(String.format("%02d-%02d", id.fragmentId, id.opId));
        } else {
            s.append("     ");
        }
        s.append("  ");
        if (id != null && id.opId == 0) {
            for (int i = 0; i < this.spacer.get(); ++i) {
                s.append('-');
            }
        } else {
            this.spacer.spaces(s);
        }
        s.append("  ");
        s.append(rel.getRelTypeName().replace("Prel", ""));
        if (this.detailLevel != SqlExplainLevel.NO_ATTRIBUTES) {
            int j = 0;
            s.append(this.getDependentSrcOp(rel));
            for (Pair<String, Object> value : values) {
                if (value.right instanceof RelNode) continue;
                if (j++ == 0) {
                    s.append("(");
                } else {
                    s.append(", ");
                }
                s.append((String)value.left).append("=[").append(value.right).append("]");
            }
            if (j > 0) {
                s.append(")");
            }
        }
        if (this.detailLevel == SqlExplainLevel.ALL_ATTRIBUTES) {
            s.append(" : rowType = ").append(rel.getRowType()).append(": rowcount = ").append(mq.getRowCount(rel)).append(", cumulative cost = ").append(mq.getCumulativeCost(rel)).append(", id = ").append(rel.getId());
        }
        this.pw.println(s);
        this.spacer.add(2);
        this.explainInputs(rel);
        this.spacer.subtract(2);
    }

    private String getDependentSrcOp(RelNode rel) {
        if (rel instanceof UnnestPrel) {
            return this.getDependentSrcOp((UnnestPrel)rel);
        }
        return "";
    }

    private String getDependentSrcOp(UnnestPrel unnest) {
        Prel parent = this.getRegisteredPrel(unnest.getParentClass());
        if (parent != null && parent instanceof LateralJoinPrel) {
            PrelSequencer.OpId id = this.ids.get(parent);
            return String.format(" [srcOp=%02d-%02d] ", id.fragmentId, id.opId);
        }
        return "";
    }

    public void register(Prel toRegister) {
        this.sourceOperatorRegistry.put(toRegister.getClass().getSimpleName(), toRegister);
    }

    public Prel getRegisteredPrel(Class<?> classname) {
        return this.sourceOperatorRegistry.get(classname.getSimpleName());
    }

    public void unRegister(Prel unregister) {
        this.sourceOperatorRegistry.remove(unregister.getClass().getSimpleName());
    }

    private void explainInputs(RelNode rel) {
        if (rel instanceof LateralJoinPrel) {
            this.explainInputs((LateralJoinPrel)rel);
        } else {
            List inputs = rel.getInputs();
            if (rel instanceof HashJoinPrel && ((HashJoinPrel)rel).isSwapped()) {
                HashJoinPrel joinPrel = (HashJoinPrel)rel;
                inputs = FlatLists.of((Object)joinPrel.getRight(), (Object)joinPrel.getLeft());
            }
            for (RelNode input : inputs) {
                input.explain((RelWriter)this);
            }
        }
    }

    private void explainInputs(LateralJoinPrel lateralJoinPrel) {
        lateralJoinPrel.getInput(0).explain((RelWriter)this);
        this.register(lateralJoinPrel);
        lateralJoinPrel.getInput(1).explain((RelWriter)this);
        this.unRegister(lateralJoinPrel);
    }

    public final void explain(RelNode rel, List<Pair<String, Object>> valueList) {
        this.explain_(rel, valueList);
    }

    public SqlExplainLevel getDetailLevel() {
        return this.detailLevel;
    }

    public RelWriter input(String term, RelNode input) {
        this.values.add((Pair<String, Object>)Pair.of((Object)term, (Object)input));
        return this;
    }

    public RelWriter item(String term, Object value) {
        this.values.add((Pair<String, Object>)Pair.of((Object)term, (Object)value));
        return this;
    }

    public RelWriter itemIf(String term, Object value, boolean condition) {
        if (condition) {
            this.item(term, value);
        }
        return this;
    }

    public RelWriter done(RelNode node) {
        int i = 0;
        if (this.values.size() > 0 && ((String)this.values.get((int)0).left).equals("subset")) {
            ++i;
        }
        for (RelNode input : node.getInputs()) {
            assert (this.values.get((int)i).right == input);
            ++i;
        }
        ImmutableList<Pair<String, Object>> valuesCopy = ImmutableList.copyOf(this.values);
        this.values.clear();
        this.explain_(node, valuesCopy);
        this.pw.flush();
        return this;
    }

    public boolean nest() {
        return false;
    }

    public String simple() {
        StringBuilder buf = new StringBuilder("(");
        for (Ord ord : Ord.zip(this.values)) {
            if (ord.i > 0) {
                buf.append(", ");
            }
            buf.append((String)((Pair)ord.e).left).append("=[").append(((Pair)ord.e).right).append("]");
        }
        buf.append(")");
        return buf.toString();
    }
}

