/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.drill.exec.planner.logical.DrillUnionRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.UnionDistinctPrel;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;

public class UnionDistinctPrule
extends Prule {
    public static final RelOptRule INSTANCE = new UnionDistinctPrule();
    protected static final Logger tracer = CalciteTrace.getPlannerTracer();

    private UnionDistinctPrule() {
        super(RelOptHelper.any(DrillUnionRel.class), "Prel.UnionDistinctPrule");
    }

    public boolean matches(RelOptRuleCall call) {
        DrillUnionRel union = (DrillUnionRel)call.rel(0);
        return union.isDistinct() && union.isHomogeneous(false);
    }

    public void onMatch(RelOptRuleCall call) {
        DrillUnionRel union = (DrillUnionRel)call.rel(0);
        List inputs = union.getInputs();
        ArrayList<RelNode> convertedInputList = Lists.newArrayList();
        RelTraitSet traits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
        try {
            for (RelNode input : inputs) {
                RelNode convertedInput = UnionDistinctPrule.convert(input, PrelUtil.fixTraits(call, traits));
                convertedInputList.add(convertedInput);
            }
            traits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)DrillDistributionTrait.SINGLETON);
            UnionDistinctPrel unionDistinct = new UnionDistinctPrel(union.getCluster(), traits, convertedInputList);
            call.transformTo((RelNode)unionDistinct);
        }
        catch (InvalidRelException e) {
            tracer.warn(e.toString());
        }
    }
}

