/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.drill.exec.planner.logical.DrillUnionRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.UnionAllPrel;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;

public class UnionAllPrule
extends Prule {
    public static final RelOptRule INSTANCE = new UnionAllPrule();
    protected static final Logger tracer = CalciteTrace.getPlannerTracer();

    private UnionAllPrule() {
        super(RelOptHelper.any(DrillUnionRel.class), "Prel.UnionAllPrule");
    }

    public boolean matches(RelOptRuleCall call) {
        DrillUnionRel union = (DrillUnionRel)call.rel(0);
        return !union.isDistinct();
    }

    public void onMatch(RelOptRuleCall call) {
        DrillUnionRel union = (DrillUnionRel)call.rel(0);
        List inputs = union.getInputs();
        ArrayList<RelNode> convertedInputList = Lists.newArrayList();
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        boolean allHashDistributed = true;
        for (RelNode child : inputs) {
            RelNode convertedChild;
            ArrayList<DrillDistributionTrait.DistributionField> childDistFields = Lists.newArrayList();
            for (RelDataTypeField f : child.getRowType().getFieldList()) {
                childDistFields.add(new DrillDistributionTrait.DistributionField(f.getIndex()));
            }
            if (settings.isUnionAllDistributeEnabled()) {
                DrillDistributionTrait hashChild = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(childDistFields));
                RelTraitSet traitsChild = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)hashChild);
                convertedChild = UnionAllPrule.convert(child, PrelUtil.fixTraits(call, traitsChild));
            } else {
                RelTraitSet traitsChild = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
                convertedChild = UnionAllPrule.convert(child, PrelUtil.fixTraits(call, traitsChild));
                allHashDistributed = false;
            }
            convertedInputList.add(convertedChild);
        }
        try {
            RelTraitSet traits = allHashDistributed ? ((RelNode)convertedInputList.get(0)).getTraitSet() : call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)DrillDistributionTrait.ANY);
            Preconditions.checkArgument(convertedInputList.size() >= 2, "Union list must be at least two items.");
            RelNode left = (RelNode)convertedInputList.get(0);
            for (int i = 1; i < convertedInputList.size(); ++i) {
                left = new UnionAllPrel(union.getCluster(), traits, ImmutableList.of(left, (RelNode)convertedInputList.get(i)));
            }
            call.transformTo(left);
        }
        catch (InvalidRelException e) {
            tracer.warn(e.toString());
        }
    }
}

