/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.UnionAll;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.UnionPrel;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class UnionAllPrel
extends UnionPrel {
    public UnionAllPrel(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs) throws InvalidRelException {
        super(cluster, traits, inputs, true);
    }

    public Union copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        try {
            return new UnionAllPrel(this.getCluster(), traitSet, inputs);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        double totalInputRowCount = 0.0;
        for (int i = 0; i < this.getInputs().size(); ++i) {
            totalInputRowCount += mq.getRowCount((RelNode)this.getInputs().get(i)).doubleValue();
        }
        double cpuCost = totalInputRowCount * 1.0;
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(totalInputRowCount, cpuCost, 0.0, 0.0);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        ArrayList<PhysicalOperator> inputPops = Lists.newArrayList();
        for (int i = 0; i < this.getInputs().size(); ++i) {
            inputPops.add(((Prel)this.getInputs().get(i)).getPhysicalOperator(creator));
        }
        UnionAll unionall = new UnionAll(inputPops);
        return creator.addMetadata(this, unionall);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }
}

