/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.TopN;
import org.apache.drill.exec.planner.common.OrderedRel;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.LimitPrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.SinglePrel;
import org.apache.drill.exec.planner.physical.SortPrel;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class TopNPrel
extends SinglePrel
implements OrderedRel,
Prel {
    protected int limit;
    protected final RelCollation collation;

    public TopNPrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, int limit, RelCollation collation) {
        super(cluster, traitSet, child);
        this.limit = limit;
        this.collation = collation;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new TopNPrel(this.getCluster(), traitSet, (RelNode)TopNPrel.sole(inputs), this.limit, this.collation);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        TopN topN = new TopN(childPOP, PrelUtil.getOrdering(this.collation, this.getInput().getRowType()), false, this.limit);
        return creator.addMetadata(this, topN);
    }

    @Override
    public RelCollation getCollation() {
        return this.collation;
    }

    @Override
    public RexNode getOffset() {
        return this.getCluster().getRexBuilder().makeExactLiteral(BigDecimal.ZERO, this.getCluster().getTypeFactory().createSqlType(SqlTypeName.INTEGER));
    }

    @Override
    public RexNode getFetch() {
        return this.getCluster().getRexBuilder().makeExactLiteral(BigDecimal.valueOf(this.limit), this.getCluster().getTypeFactory().createSqlType(SqlTypeName.INTEGER));
    }

    @Override
    public boolean canBeDropped() {
        return true;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.05);
        }
        RelNode child = this.getInput();
        double inputRows = mq.getRowCount(child);
        int numSortFields = this.collation.getFieldCollations().size();
        double cpuCost = (double)(4 * numSortFields) * inputRows * (Math.log(this.limit) / Math.log(2.0));
        double diskIOCost = 0.0;
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(inputRows, cpuCost, diskIOCost, 0.0);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("limit", (Object)this.limit);
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.NONE_AND_TWO;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.FOUR_BYTE;
    }

    @Override
    public Prel prepareForLateralUnnestPipeline(List<RelNode> children) {
        ArrayList<RelFieldCollation> relFieldCollations = Lists.newArrayList();
        relFieldCollations.add(new RelFieldCollation(0, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.FIRST));
        for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
            relFieldCollations.add(new RelFieldCollation(fieldCollation.getFieldIndex() + 1, fieldCollation.direction, fieldCollation.nullDirection));
        }
        RelCollation collationTrait = RelCollations.of(relFieldCollations);
        RelTraitSet traits = RelTraitSet.createEmpty().replace(this.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE)).replace((RelTrait)collationTrait).replace((RelTrait)DRILL_PHYSICAL);
        return this.transformTopNToSortAndLimit(children, traits, collationTrait);
    }

    private Prel transformTopNToSortAndLimit(List<RelNode> children, RelTraitSet traits, RelCollation collationTrait) {
        SortPrel sortprel = new SortPrel(this.getCluster(), traits, children.get(0), collationTrait);
        RexLiteral offset = this.getCluster().getRexBuilder().makeExactLiteral(BigDecimal.valueOf(0L), this.getCluster().getTypeFactory().createSqlType(SqlTypeName.INTEGER));
        RexLiteral limit = this.getCluster().getRexBuilder().makeExactLiteral(BigDecimal.valueOf(this.limit), this.getCluster().getTypeFactory().createSqlType(SqlTypeName.INTEGER));
        LimitPrel limitPrel = new LimitPrel(this.getCluster(), traits, sortprel, (RexNode)offset, (RexNode)limit, false, true);
        return limitPrel;
    }
}

