/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.StreamingAggregate;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.AggPrelBase;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAggPrel
extends AggPrelBase
implements Prel {
    static final Logger logger = LoggerFactory.getLogger(StreamAggPrel.class);

    public StreamAggPrel(RelOptCluster cluster, RelTraitSet traits, RelNode child, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls, AggPrelBase.OperatorPhase phase) throws InvalidRelException {
        super(cluster, traits, child, groupSet, groupSets, aggCalls, phase);
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new StreamAggPrel(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls, this.getOperatorPhase());
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        RelNode child = this.getInput();
        double inputRows = mq.getRowCount(child);
        int numGroupByFields = this.getGroupCount();
        int numAggrFields = this.aggCalls.size();
        double cpuCost = (double)(4 * numGroupByFields) * inputRows;
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(inputRows, cpuCost += (double)(12 * numAggrFields) * inputRows, 0.0, 0.0);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        StreamingAggregate g = new StreamingAggregate(child.getPhysicalOperator(creator), this.keys, this.aggExprs);
        return creator.addMetadata(this, g);
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getInput());
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitPrel(this, value);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.ALL;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }
}

