/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillSortRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SingleMergeExchangePrel;
import org.apache.drill.exec.planner.physical.SortPrel;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class SortPrule
extends Prule {
    public static final RelOptRule INSTANCE = new SortPrule();

    private SortPrule() {
        super(RelOptHelper.any(DrillSortRel.class, (RelTrait)DrillRel.DRILL_LOGICAL), "Prel.SortPrule");
    }

    public void onMatch(RelOptRuleCall call) {
        DrillSortRel sort = (DrillSortRel)call.rel(0);
        DrillDistributionTrait hashDistribution = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(sort)));
        RelTraitSet traits = RelTraitSet.createEmpty().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)hashDistribution);
        SortPrel child = new SortPrel(sort.getCluster(), traits.plus((RelTrait)sort.getCollation()), SortPrule.convert(sort.getInput(), traits), sort.getCollation(), false);
        if (SortPrule.isSingleMode(call)) {
            call.transformTo((RelNode)child);
        } else {
            SingleMergeExchangePrel exch = new SingleMergeExchangePrel(sort.getCluster(), sort.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)DrillDistributionTrait.SINGLETON), child, sort.getCollation());
            call.transformTo((RelNode)exch);
        }
    }

    private List<DrillDistributionTrait.DistributionField> getDistributionField(DrillSortRel rel) {
        ArrayList<DrillDistributionTrait.DistributionField> distFields = Lists.newArrayList();
        for (RelFieldCollation relField : rel.getCollation().getFieldCollations()) {
            DrillDistributionTrait.DistributionField field = new DrillDistributionTrait.DistributionField(relField.getFieldIndex());
            distFields.add(field);
        }
        return distFields;
    }
}

