/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.ExternalSort;
import org.apache.drill.exec.planner.common.DrillSortRelBase;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class SortPrel
extends DrillSortRelBase
implements Prel {
    private final boolean isRemovable;

    public SortPrel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RelCollation collation) {
        super(cluster, traits, input, collation);
        this.isRemovable = true;
    }

    public SortPrel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traits, input, collation, offset, fetch);
        this.isRemovable = true;
    }

    public SortPrel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RelCollation collation, boolean isRemovable) {
        super(cluster, traits, input, collation);
        this.isRemovable = isRemovable;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        RelNode child = this.getInput();
        double inputRows = mq.getRowCount(child);
        int numSortFields = this.collation.getFieldCollations().size();
        double cpuCost = (double)(4 * numSortFields) * inputRows * (Math.log(inputRows) / Math.log(2.0));
        double diskIOCost = 0.0;
        double numFields = this.getRowType().getFieldCount();
        long fieldWidth = PrelUtil.getPlannerSettings((RelOptPlanner)planner).getOptions().getOption((String)"planner.memory.average_field_width").num_val;
        double memCost = (double)fieldWidth * numFields * inputRows;
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(inputRows, cpuCost, diskIOCost, 0.0, memCost);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        ExternalSort g = new ExternalSort(childPOP, PrelUtil.getOrdering(this.collation, this.getInput().getRowType()), false);
        return creator.addMetadata(this, g);
    }

    public SortPrel copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new SortPrel(this.getCluster(), traitSet, newInput, newCollation);
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getInput());
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitPrel(this, value);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.NONE_AND_TWO;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.FOUR_BYTE;
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return true;
    }

    @Override
    public Prel prepareForLateralUnnestPipeline(List<RelNode> children) {
        ArrayList<RelFieldCollation> relFieldCollations = Lists.newArrayList();
        relFieldCollations.add(new RelFieldCollation(0, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.FIRST));
        for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
            relFieldCollations.add(new RelFieldCollation(fieldCollation.getFieldIndex() + 1, fieldCollation.direction, fieldCollation.nullDirection));
        }
        RelCollation collationTrait = RelCollationImpl.of(relFieldCollations);
        RelTraitSet traits = RelTraitSet.createEmpty().replace(this.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE)).replace((RelTrait)collationTrait).replace((RelTrait)DRILL_PHYSICAL);
        return this.copy(traits, children.get(0), collationTrait, this.offset, this.fetch);
    }

    @Override
    public boolean canBeDropped() {
        return this.isRemovable;
    }
}

