/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.SingleMergeExchange;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.OrderedMuxExchangePrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.server.options.OptionManager;

public class SingleMergeExchangePrel
extends ExchangePrel {
    private final RelCollation collation;

    public SingleMergeExchangePrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation) {
        super(cluster, traitSet, input);
        this.collation = collation;
        assert (input.getConvention() == Prel.DRILL_PHYSICAL);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        RelNode child = this.getInput();
        double inputRows = mq.getRowCount(child);
        int rowWidth = child.getRowType().getFieldCount() * 8;
        double svrCpuCost = 8.0 * inputRows;
        double networkCost = 512.0 * inputRows * (double)rowWidth;
        int numEndPoints = PrelUtil.getSettings(this.getCluster()).numEndPoints();
        double mergeCpuCost = 4.0 * inputRows * (Math.log(numEndPoints) / Math.log(2.0));
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(inputRows, svrCpuCost + mergeCpuCost, 0.0, networkCost);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new SingleMergeExchangePrel(this.getCluster(), traitSet, (RelNode)SingleMergeExchangePrel.sole(inputs), this.collation);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        if (PrelUtil.getSettings(this.getCluster()).isSingleMode()) {
            return childPOP;
        }
        SingleMergeExchange g = new SingleMergeExchange(childPOP, PrelUtil.getOrdering(this.collation, this.getInput().getRowType()));
        return creator.addMetadata(this, g);
    }

    @Override
    public Prel constructMuxPrel(Prel child, OptionManager options) throws RuntimeException {
        Prel outPrel = child;
        if (options.getOption((String)PlannerSettings.ORDERED_MUX_EXCHANGE.getOptionName()).bool_val.booleanValue() && options.getOption((String)PlannerSettings.MUX_EXCHANGE.getOptionName()).bool_val.booleanValue()) {
            outPrel = new OrderedMuxExchangePrel(this.getCluster(), this.getTraitSet(), this.getInput(), this.getCollation());
        }
        return new SingleMergeExchangePrel(this.getCluster(), this.getTraitSet(), outPrel, this.getCollation());
    }

    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        if (pw.nest()) {
            pw.item("collation", (Object)this.collation);
        } else {
            for (Ord ord : Ord.zip((List)this.collation.getFieldCollations())) {
                pw.item("sort" + ord.i, ord.e);
            }
        }
        return pw;
    }

    public RelCollation getCollation() {
        return this.collation;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }
}

