/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.planner.logical.DrillExceptRel;
import org.apache.drill.exec.planner.logical.DrillIntersectRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.AggPrelBase;
import org.apache.drill.exec.planner.physical.AggPruleBase;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.HashAggPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SetOpPrel;
import org.apache.drill.exec.planner.physical.StreamAggPrel;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;

public class SetOpPrule
extends Prule {
    public static final List<RelOptRule> DIST_INSTANCES = Arrays.asList(new RelOptRule[]{new SetOpPrule(RelOptHelper.any(DrillExceptRel.class), "Prel.HashExceptDistPrule", true), new SetOpPrule(RelOptHelper.any(DrillIntersectRel.class), "Prel.HashIntersectDistPrule", true)});
    public static final List<RelOptRule> BROADCAST_INSTANCES = Arrays.asList(new RelOptRule[]{new SetOpPrule(RelOptHelper.any(DrillExceptRel.class), "Prel.HashExceptBroadcastPrule", false), new SetOpPrule(RelOptHelper.any(DrillIntersectRel.class), "Prel.HashIntersectBroadcastPrule", false)});
    protected static final Logger tracer = CalciteTrace.getPlannerTracer();
    private final boolean isDist;

    private SetOpPrule(RelOptRuleOperand operand, String description, boolean isDist) {
        super(operand, description);
        this.isDist = isDist;
    }

    public void onMatch(RelOptRuleCall call) {
        SetOp setOp = (SetOp)call.rel(0);
        Preconditions.checkArgument(setOp.getInputs().size() == 2, "inputs of set op must be two items.");
        try {
            if (this.isDist) {
                this.createDistBothPlan(call);
            } else if (this.checkBroadcastConditions(setOp.getCluster(), setOp.getInput(0), setOp.getInput(1))) {
                this.createBroadcastPlan(call);
            }
        }
        catch (InvalidRelException e) {
            tracer.warn(e.toString());
        }
    }

    private void createDistBothPlan(RelOptRuleCall call) throws InvalidRelException {
        int fieldCount = call.rel(0).getInput(0).getRowType().getFieldCount();
        ArrayList<DrillDistributionTrait.DistributionField> distFields = Lists.newArrayList();
        for (int i = 0; i < fieldCount; ++i) {
            distFields.add(new DrillDistributionTrait.DistributionField(i));
        }
        DrillDistributionTrait distributionTrait = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, distFields);
        this.createPlan(call, distributionTrait);
        if (!PrelUtil.getPlannerSettings(call.getPlanner()).isHashSingleKey()) {
            return;
        }
        if (fieldCount > 1) {
            for (int j = 0; j < fieldCount; ++j) {
                distributionTrait = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.of(new DrillDistributionTrait.DistributionField(j)));
                this.createPlan(call, distributionTrait);
            }
        }
    }

    private boolean checkBroadcastConditions(RelOptCluster cluster, RelNode left, RelNode right) {
        double estimatedRightRowCount = RelMetadataQuery.instance().getRowCount(right);
        return estimatedRightRowCount < (double)PrelUtil.getSettings(cluster).getBroadcastThreshold() && !DrillDistributionTrait.SINGLETON.equals(left.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE));
    }

    private void createBroadcastPlan(RelOptRuleCall call) throws InvalidRelException {
        DrillDistributionTrait distBroadcastRight = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.BROADCAST_DISTRIBUTED);
        this.createPlan(call, distBroadcastRight);
    }

    private void createPlan(RelOptRuleCall call, DrillDistributionTrait setOpTrait) throws InvalidRelException {
        if (this.needAddAgg((SetOp)call.rel(0))) {
            ImmutableBitSet groupSet = ImmutableBitSet.range((int)0, (int)call.rel(0).getInput(0).getRowType().getFieldList().size());
            DrillDistributionTrait distOnAllKeys = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(groupSet, true)));
            RelTraitSet aggTraits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)distOnAllKeys);
            this.createTransformRequest(call, aggTraits, setOpTrait, null);
            DrillDistributionTrait distOnOneKey = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(groupSet, false)));
            aggTraits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)distOnOneKey);
            this.createTransformRequest(call, aggTraits, setOpTrait, null);
            RelCollation collation = this.getCollation(groupSet);
            aggTraits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)collation).plus((RelTrait)distOnAllKeys);
            this.createTransformRequest(call, aggTraits, setOpTrait, collation);
        } else {
            call.transformTo((RelNode)this.buildSetOpPrel(call, null, setOpTrait));
        }
    }

    private boolean needAddAgg(SetOp setOp) {
        if (setOp.all || !(setOp instanceof DrillExceptRel)) {
            return false;
        }
        Set uniqueKeys = setOp.getCluster().getMetadataQuery().getUniqueKeys(((RelSubset)setOp.getInput(0)).getBestOrOriginal());
        if (uniqueKeys == null) {
            return true;
        }
        return uniqueKeys.size() < setOp.getRowType().getFieldCount();
    }

    private void createTransformRequest(RelOptRuleCall call, RelTraitSet aggTraits, DrillDistributionTrait setOpTrait, RelCollation collation) throws InvalidRelException {
        Prel outputRel;
        boolean addAggBelow = PrelUtil.getPlannerSettings(call.getPlanner()).getOptions().getOption(ExecConstants.EXCEPT_ADD_AGG_BELOW);
        if (addAggBelow) {
            AggPrelBase newAgg = this.buildAggPrel(call, call.rel(0).getInput(0), aggTraits, collation);
            outputRel = this.buildSetOpPrel(call, newAgg, setOpTrait);
        } else {
            SetOpPrel setOpPrel = this.buildSetOpPrel(call, null, setOpTrait);
            outputRel = this.buildAggPrel(call, setOpPrel, aggTraits, collation);
        }
        call.transformTo((RelNode)outputRel);
    }

    private AggPrelBase buildAggPrel(RelOptRuleCall call, RelNode input, RelTraitSet aggTraits, RelCollation collation) throws InvalidRelException {
        DrillExceptRel drillExceptRel = (DrillExceptRel)call.rel(0);
        ImmutableBitSet groupSet = ImmutableBitSet.range((int)0, (int)drillExceptRel.getInput(0).getRowType().getFieldList().size());
        if (collation != null) {
            RelNode convertedInput = SetOpPrule.convert(input, aggTraits);
            return new StreamAggPrel(drillExceptRel.getCluster(), aggTraits, convertedInput, groupSet, ImmutableList.of(), ImmutableList.of(), AggPrelBase.OperatorPhase.PHASE_1of1);
        }
        RelNode convertedInput = SetOpPrule.convert(input, PrelUtil.fixTraits(call, aggTraits));
        return new HashAggPrel(drillExceptRel.getCluster(), aggTraits, convertedInput, groupSet, ImmutableList.of(), ImmutableList.of(), AggPrelBase.OperatorPhase.PHASE_1of1);
    }

    private SetOpPrel buildSetOpPrel(RelOptRuleCall call, RelNode convertedLeft, DrillDistributionTrait setOpTrait) throws InvalidRelException {
        SetOp setOp = (SetOp)call.rel(0);
        RelNode right = setOp.getInput(1);
        RelTraitSet traitsRight = right.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)setOpTrait);
        RelNode convertedRight = SetOpPrule.convert(right, traitsRight);
        if (convertedLeft == null) {
            RelNode left = setOp.getInput(0);
            RelTraitSet traitsLeft = left.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
            if (DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED.equals((Object)setOpTrait.getType())) {
                traitsLeft.plus((RelTrait)setOpTrait);
            }
            convertedLeft = SetOpPrule.convert(left, traitsLeft);
        }
        RelTraitSet traitSet = PrelUtil.removeCollation(convertedLeft.getTraitSet(), call);
        return new SetOpPrel(convertedLeft.getCluster(), traitSet, ImmutableList.of(convertedLeft, convertedRight), setOp.kind, setOp.all);
    }

    private List<DrillDistributionTrait.DistributionField> getDistributionField(ImmutableBitSet groupSet, boolean allFields) {
        ArrayList<DrillDistributionTrait.DistributionField> groupByFields = Lists.newArrayList();
        Iterator iterator = AggPruleBase.remapGroupSet(groupSet).iterator();
        while (iterator.hasNext()) {
            int group = (Integer)iterator.next();
            DrillDistributionTrait.DistributionField field = new DrillDistributionTrait.DistributionField(group);
            groupByFields.add(field);
            if (allFields || groupByFields.size() != 1) continue;
            break;
        }
        return groupByFields;
    }

    private RelCollation getCollation(ImmutableBitSet groupSet) {
        ArrayList<RelFieldCollation> fields = Lists.newArrayList();
        Iterator iterator = BitSets.toIter((ImmutableBitSet)groupSet).iterator();
        while (iterator.hasNext()) {
            int group = (Integer)iterator.next();
            fields.add(new RelFieldCollation(group));
        }
        return RelCollations.of(fields);
    }
}

