/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.fragment.DistributionAffinity;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.ScanPrel;

public class ScanPrule
extends Prule {
    public static final RelOptRule INSTANCE = new ScanPrule();

    public ScanPrule() {
        super(RelOptHelper.any(DrillScanRel.class), "Prel.ScanPrule");
    }

    public void onMatch(RelOptRuleCall call) {
        DrillScanRel scan = (DrillScanRel)call.rel(0);
        GroupScan groupScan = scan.getGroupScan();
        DrillDistributionTrait partition = groupScan.getMaxParallelizationWidth() > 1 || groupScan.getDistributionAffinity() == DistributionAffinity.HARD ? DrillDistributionTrait.RANDOM_DISTRIBUTED : DrillDistributionTrait.SINGLETON;
        RelTraitSet traits = scan.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)partition);
        ScanPrel newScan = new ScanPrel(scan.getCluster(), traits, groupScan, scan.getRowType(), scan.getTable());
        call.transformTo((RelNode)newScan);
    }
}

