/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.logical.RowKeyJoinRel;
import org.apache.drill.exec.planner.physical.JoinPruleBase;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowKeyJoinPrule
extends JoinPruleBase {
    public static final RelOptRule INSTANCE = new RowKeyJoinPrule("Prel.RowKeyJoinPrule", RelOptHelper.any(RowKeyJoinRel.class));
    static final Logger logger = LoggerFactory.getLogger(RowKeyJoinPrule.class);

    private RowKeyJoinPrule(String name, RelOptRuleOperand operand) {
        super(operand, name);
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode right;
        RelNode left;
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        RowKeyJoinRel join = (RowKeyJoinRel)call.rel(0);
        if (!this.checkPreconditions(join, left = join.getLeft(), right = join.getRight(), settings)) {
            return;
        }
        try {
            if (!settings.isRowKeyJoinConversionUsingHashJoin()) {
                this.createRangePartitionRightPlan(call, join, JoinPruleBase.PhysicalJoinType.HASH_JOIN, true, left, right, null, null);
            } else {
                this.createRangePartitionRightPlan(call, join, JoinPruleBase.PhysicalJoinType.HASH_JOIN, false, left, right, null, null);
            }
        }
        catch (Exception e) {
            logger.warn(e.toString());
        }
    }
}

