/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.LimitPrel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SingleMergeExchangePrel;
import org.apache.drill.exec.planner.physical.SortPrel;
import org.apache.drill.exec.planner.physical.TopNPrel;

public class PushLimitToTopN
extends Prule {
    public static final RelOptRule INSTANCE = new PushLimitToTopN();

    private PushLimitToTopN() {
        super(RelOptHelper.some(LimitPrel.class, RelOptHelper.some(SingleMergeExchangePrel.class, RelOptHelper.any(SortPrel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "PushLimitToTopN");
    }

    public boolean matches(RelOptRuleCall call) {
        boolean topNEnabled = PrelUtil.getPlannerSettings((RelOptPlanner)call.getPlanner()).getOptions().getOption((String)PlannerSettings.TOPN.getOptionName()).bool_val;
        if (!topNEnabled) {
            return false;
        }
        LimitPrel limit = (LimitPrel)call.rel(0);
        return limit.getFetch() != null;
    }

    public void onMatch(RelOptRuleCall call) {
        LimitPrel limit = (LimitPrel)call.rel(0);
        SingleMergeExchangePrel smex = (SingleMergeExchangePrel)call.rel(1);
        SortPrel sort = (SortPrel)call.rel(2);
        int offset = limit.getOffset() != null ? Math.max(0, RexLiteral.intValue((RexNode)limit.getOffset())) : 0;
        int fetch = Math.max(0, RexLiteral.intValue((RexNode)limit.getFetch()));
        TopNPrel topN = new TopNPrel(limit.getCluster(), sort.getTraitSet(), sort.getInput(), offset + fetch, sort.getCollation());
        LimitPrel newLimit = new LimitPrel(limit.getCluster(), limit.getTraitSet(), new SingleMergeExchangePrel(smex.getCluster(), smex.getTraitSet(), topN, sort.getCollation()), limit.getOffset(), limit.getFetch());
        call.transformTo((RelNode)newLimit);
    }
}

